/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.datagen;

import appeng.core.AppEng;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.integration.appmek.AppMekCellType;
import gripe._90.megacells.integration.appmek.AppMekItems;
import gripe._90.megacells.item.MEGAItems;
import gripe._90.megacells.item.core.MEGACellType;
import gripe._90.megacells.item.core.MEGATier;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class MEGAItemModelProvider
extends ItemModelProvider {
    static final ResourceLocation STORAGE_CELL_LED = AppEng.makeId((String)"item/storage_cell_led");
    static final ResourceLocation PORTABLE_CELL_LED = AppEng.makeId((String)"item/portable_cell_led");

    public MEGAItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "megacells", existingFileHelper);
        existingFileHelper.trackGenerated(STORAGE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        existingFileHelper.trackGenerated(PORTABLE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
    }

    protected void registerModels() {
        this.flatSingleLayer((Item)MEGAItems.MEGA_ITEM_CELL_HOUSING.m_5456_());
        this.flatSingleLayer((Item)MEGAItems.MEGA_FLUID_CELL_HOUSING.m_5456_());
        this.flatSingleLayer((Item)AppMekItems.MEGA_CHEMICAL_CELL_HOUSING.m_5456_());
        for (MEGATier tier : MEGATier.values()) {
            this.flatSingleLayer(tier.getComponent());
        }
        for (Item storage : Stream.of(MEGACellType.ITEM.getCells().stream(), MEGACellType.FLUID.getCells().stream(), AppMekCellType.CHEMICAL.getCells().stream()).flatMap(s -> s).toList()) {
            this.cell(storage);
        }
        this.flatSingleLayer((Item)MEGAItems.BULK_CELL_COMPONENT.m_5456_());
        this.cell((Item)MEGAItems.BULK_ITEM_CELL.m_5456_());
        this.flatSingleLayer((Item)AppMekItems.RADIOACTIVE_CELL_COMPONENT.m_5456_());
        this.cell((Item)AppMekItems.RADIOACTIVE_CHEMICAL_CELL.m_5456_());
        for (Item portable : Stream.of(MEGACellType.ITEM.getPortableCells().stream(), MEGACellType.FLUID.getPortableCells().stream(), AppMekCellType.CHEMICAL.getPortableCells().stream()).flatMap(s -> s).toList()) {
            this.portable(portable);
        }
    }

    private void cell(Item cell) {
        this.flatSingleLayer(cell, "/cells/standard").texture("layer1", STORAGE_CELL_LED);
    }

    private void portable(Item cell) {
        this.flatSingleLayer(cell, "/cells/portable").texture("layer1", PORTABLE_CELL_LED);
    }

    private void flatSingleLayer(Item item) {
        this.flatSingleLayer(item, "");
    }

    private ItemModelBuilder flatSingleLayer(Item item, String subfolder) {
        String path = MEGACells.getItemPath(item);
        return (ItemModelBuilder)this.singleTexture(path, this.mcLoc("item/generated"), "layer0", MEGACells.makeId("item" + subfolder + "/" + path));
    }
}

