/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.block;

import appeng.block.crafting.CraftingMonitorBlock;
import appeng.block.crafting.CraftingUnitBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.block.networking.EnergyCellBlock;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import com.google.common.base.Preconditions;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.block.MEGACraftingBlockItem;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.block.MEGAEnergyCellBlockItem;
import gripe._90.megacells.item.MEGAItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.NotNull;

public final class MEGABlocks {
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    private static final BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.2f, 11.0f).m_60918_(SoundType.f_56743_);
    public static final BlockDefinition<EnergyCellBlock> MEGA_ENERGY_CELL = MEGABlocks.block("mega_energy_cell", () -> new EnergyCellBlock(1.28E7, 12800), MEGAEnergyCellBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> MEGA_CRAFTING_UNIT = MEGABlocks.block("mega_crafting_unit", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.UNIT), null);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_ACCELERATOR = MEGABlocks.craftingBlock("mega_crafting_accelerator", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.ACCELERATOR), () -> AEItems.ENGINEERING_PROCESSOR);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_1M = MEGABlocks.craftingBlock("1m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_1M), () -> MEGAItems.CELL_COMPONENT_1M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_4M = MEGABlocks.craftingBlock("4m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_4M), () -> MEGAItems.CELL_COMPONENT_4M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_16M = MEGABlocks.craftingBlock("16m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_16M), () -> MEGAItems.CELL_COMPONENT_16M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_64M = MEGABlocks.craftingBlock("64m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_64M), () -> MEGAItems.CELL_COMPONENT_64M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_256M = MEGABlocks.craftingBlock("256m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_256M), () -> MEGAItems.CELL_COMPONENT_256M);
    public static final BlockDefinition<CraftingMonitorBlock> CRAFTING_MONITOR = MEGABlocks.craftingBlock("mega_crafting_monitor", () -> new CraftingMonitorBlock(props, (ICraftingUnitType)MEGACraftingUnitType.MONITOR), () -> AEParts.STORAGE_MONITOR);

    public static void init() {
    }

    public static List<BlockDefinition<?>> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    private static <T extends Block> BlockDefinition<T> craftingBlock(String id, Supplier<T> blockSupplier, Supplier<ItemLike> disassemblyExtra) {
        return MEGABlocks.block(id, blockSupplier, (block, props) -> new MEGACraftingBlockItem((Block)block, (Item.Properties)props, disassemblyExtra));
    }

    private static <T extends Block> BlockDefinition<T> block(String id, Supplier<T> blockSupplier, @Nullable BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        BlockItem item;
        Block block = (Block)blockSupplier.get();
        Item.Properties itemProperties = new Item.Properties().m_41491_(MEGACells.CREATIVE_TAB);
        if (itemFactory != null) {
            item = itemFactory.apply(block, itemProperties);
            if (item == null) {
                throw new IllegalArgumentException("BlockItem factory for " + id + " returned null");
            }
        } else {
            item = new BlockItem(block, itemProperties);
        }
        BlockDefinition<Block> definition = new BlockDefinition<Block>(MEGACells.makeId(id), block, item);
        BLOCKS.add(definition);
        return definition;
    }

    public static class BlockDefinition<T extends Block>
    extends MEGAItems.ItemDefinition<BlockItem> {
        private final T block;

        public BlockDefinition(ResourceLocation id, T block, BlockItem item) {
            super(id, item);
            this.block = (Block)Objects.requireNonNull(block, "block");
        }

        @NotNull
        public final T asBlock() {
            return this.block;
        }

        public final ItemStack stack(int stackSize) {
            Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
            return new ItemStack(this.block, stackSize);
        }
    }
}

