/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetManagedMachine
extends MessageBase {
    public MachineReference managedMachine;

    public MessageSetManagedMachine(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetManagedMachine(MachineReference managedMachine) {
        this.managedMachine = managedMachine;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41720_() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast).ifPresent(job -> {
                if (job.getManagedMachine() != null) {
                    job.getManagedMachine().customName = this.managedMachine.customName;
                    job.getManagedMachine().extractFacing = this.managedMachine.extractFacing;
                    job.getManagedMachine().insertFacing = this.managedMachine.insertFacing;
                    ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                    player.f_36095_.m_38946_();
                }
            }));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.managedMachine.encode(buf);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.managedMachine = MachineReference.from(buf);
    }
}

