/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.entity.FairyFamiliarEntity;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class MessageFairySupport
extends MessageBase {
    private int fairyId;
    private int targetId;

    public MessageFairySupport(int fairyId, int targetId) {
        this.fairyId = fairyId;
        this.targetId = targetId;
    }

    public MessageFairySupport(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.fairyId);
        buf.writeInt(this.targetId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.fairyId = buf.readInt();
        this.targetId = buf.readInt();
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player, NetworkEvent.Context context) {
        Entity target;
        Entity fairy = minecraft.f_91073_.m_6815_(this.fairyId);
        if (fairy instanceof FairyFamiliarEntity) {
            ((FairyFamiliarEntity)fairy).startSupportAnimation();
        }
        if ((target = minecraft.f_91073_.m_6815_(this.targetId)) != null) {
            for (int i = 0; i < 30; ++i) {
                Vec3 pos = new Vec3(target.m_20208_(1.0), target.m_20187_(), target.m_20262_(1.0));
                minecraft.f_91073_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.9f, 0.5f), 1.0f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }
}

