/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.crops.IReplantableCrops;
import com.github.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.github.klikli_dev.occultism.datagen.BaseLootTableProvider;
import com.github.klikli_dev.occultism.datagen.StandardBlockLootTables;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismEntities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class StandardLootTableProvider
extends BaseLootTableProvider {
    protected static final float[] INCREASED_SAPLING_DROP_RATES = new float[]{0.1f, 0.2f, 0.3f, 0.4f};
    InternalBlockLootTable blockLoot = new InternalBlockLootTable();
    InternalEntityLootTable entityLoot = new InternalEntityLootTable();

    public StandardLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        this.blockLoot.addTables();
        this.entityLoot.addTables();
    }

    private class InternalBlockLootTable
    extends StandardBlockLootTables {
        private InternalBlockLootTable() {
        }

        protected void addTables() {
            OccultismBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                OccultismBlocks.BlockDataGenSettings settings = OccultismBlocks.BLOCK_DATA_GEN_SETTINGS.get(block.getRegistryName());
                if (settings.lootTableType == OccultismBlocks.LootTableType.EMPTY) {
                    this.registerDropNothingLootTable((Block)block);
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.REPLANTABLE_CROP) {
                    IReplantableCrops cropsBlock = (IReplantableCrops)block;
                    LootItemBlockStatePropertyCondition.Builder lootCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7));
                    this.m_124165_((Block)block, InternalBlockLootTable.m_124142_((Block)block, (Item)cropsBlock.getCropsItem().m_5456_(), (Item)cropsBlock.getSeedsItem().m_5456_(), (LootItemCondition.Builder)lootCondition));
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.DROP_SELF) {
                    this.m_124288_((Block)block);
                } else if (settings.lootTableType == OccultismBlocks.LootTableType.OTHERWORLD_BLOCK) {
                    this.registerOtherworldBlockTable((Block)block);
                }
            });
            this.m_124175_((Block)OccultismBlocks.OTHERWORLD_LEAVES.get(), block -> InternalBlockLootTable.m_124157_((Block)block, (Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.m_124175_((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get(), block -> this.createOtherworldLeavesDrops((Block)block, Blocks.f_50746_, (Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get(), INCREASED_SAPLING_DROP_RATES));
            this.m_124165_((Block)OccultismBlocks.SILVER_ORE.get(), InternalBlockLootTable.m_124139_((Block)((Block)OccultismBlocks.SILVER_ORE.get()), (Item)((Item)OccultismItems.RAW_SILVER.get())));
            this.m_124165_((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), InternalBlockLootTable.m_124139_((Block)((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get()), (Item)((Item)OccultismItems.RAW_SILVER.get())));
            this.m_124165_((Block)OccultismBlocks.IESNIUM_ORE.get(), InternalBlockLootTable.m_124139_((Block)((Block)OccultismBlocks.IESNIUM_ORE.get()), (Item)((Item)OccultismItems.RAW_IESNIUM.get())));
        }

        protected void m_124165_(Block blockIn, LootTable.Builder table) {
            StandardLootTableProvider.this.blockLootTable.put(blockIn, table);
        }

        protected void registerOtherworldBlockTable(Block block) {
            if (block instanceof IOtherworldBlock) {
                this.m_124165_(block, this.createOtherworldBlockTable(block));
            } else {
                Occultism.LOGGER.warn("Tried to register otherworld block loot table for non-otherworld block {}", (Object)block.getRegistryName());
            }
        }

        protected LootTable.Builder createOtherworldBlockTable(Block block) {
            IOtherworldBlock otherworldBlock = (IOtherworldBlock)block;
            return this.createOtherworldBlockTable(block, (ItemLike)otherworldBlock.getCoveredBlock(), (ItemLike)otherworldBlock.getUncoveredBlock());
        }

        protected LootTable.Builder createOtherworldBlockTable(Block block, ItemLike coveredDrop, ItemLike uncoveredDrop) {
            LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_(IOtherworldBlock.UNCOVERED, true));
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)uncoveredDrop).m_6509_((LootItemCondition.Builder)uncoveredCondition)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)coveredDrop)));
            return LootTable.m_79147_().m_79161_(builder);
        }

        protected LootTable.Builder createOtherworldLeavesDrops(Block leavesBlock, Block coveredSapling, Block uncoveredSapling, float ... chances) {
            LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)leavesBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_(IOtherworldBlock.UNCOVERED, true));
            AlternativesEntry.Builder saplingLootItem = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)uncoveredSapling).m_6509_((LootItemCondition.Builder)uncoveredCondition)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)coveredSapling));
            return InternalBlockLootTable.m_124283_((Block)leavesBlock, (LootPoolEntryContainer.Builder)((AlternativesEntry.Builder)InternalBlockLootTable.m_124134_((ItemLike)leavesBlock, (ConditionUserBuilder)saplingLootItem)).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(NOT_SILK_TOUCH_OR_SHEARS).m_79076_(((LootPoolSingletonContainer.Builder)InternalBlockLootTable.m_124131_((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }
    }

    private class InternalEntityLootTable
    extends EntityLoot {
        private InternalEntityLootTable() {
        }

        protected void addTables() {
            this.m_124371_((EntityType)OccultismEntities.POSSESSED_ENDERMITE_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42102_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)OccultismEntities.POSSESSED_ENDERMAN_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)OccultismEntities.POSSESSED_SKELETON_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42678_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)OccultismEntities.AFRIT_WILD_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)OccultismItems.AFRIT_ESSENCE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.7f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_124371_((EntityType)OccultismEntities.WILD_HUNT_WITHER_SKELETON_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-1.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50312_)).m_6509_(LootItemKilledByPlayerCondition.m_81901_()).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))));
            this.m_124371_((EntityType)OccultismEntities.WILD_HUNT_SKELETON_TYPE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        protected void m_124371_(EntityType<?> type, LootTable.Builder table) {
            StandardLootTableProvider.this.entityLootTable.put(type, table);
        }
    }
}

