/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismClientConfig {
    public final VisualSettings visuals;
    public final MiscSettings misc;
    public final ForgeConfigSpec spec;

    public OccultismClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.visuals = new VisualSettings(builder);
        this.misc = new MiscSettings(builder);
        this.spec = builder.build();
    }

    public static class VisualSettings {
        public final ForgeConfigSpec.BooleanValue disableDemonsDreamShaders;
        public final ForgeConfigSpec.BooleanValue disableHolidayTheming;

        public VisualSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Visual Settings").push("visual");
            this.disableDemonsDreamShaders = builder.comment("Disables the headache- and possibly seizure-inducing visual effects of Demon's Dream.").define("disableDemonsDreamShaders", false);
            this.disableHolidayTheming = builder.comment("Disables holiday themed visual content such as familiar skins.").define("disableHolidayTheming", false);
            builder.pop();
        }
    }

    public static class MiscSettings {
        public final ForgeConfigSpec.BooleanValue syncJeiSearch;
        public final ForgeConfigSpec.BooleanValue divinationRodHighlightAllResults;
        public final ForgeConfigSpec.IntValue divinationRodScanRange;

        public MiscSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Misc Settings").push("misc");
            this.syncJeiSearch = builder.comment("Sync JEI search in storage actuator.").define("syncJeiSearch", false);
            this.divinationRodHighlightAllResults = builder.comment("If true, divination rod will render all matching blocks with an outline. Disable if it causes lag.").define("divinationRodHighlightAllResults", false);
            this.divinationRodScanRange = builder.comment("The scan range in blocks for the divination rod. Too high might cause lags").defineInRange("divinationRodScanRange", 129, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

