/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.level.multichunk;

import com.github.klikli_dev.occultism.common.level.multichunk.IMultiChunkSubFeature;
import com.github.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.util.BiomeUtil;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MultiChunkFeature
extends Feature<MultiChunkFeatureConfig> {
    public final IMultiChunkSubFeature subFeature;

    public MultiChunkFeature(Codec<MultiChunkFeatureConfig> codec, IMultiChunkSubFeature subFeature) {
        super(codec);
        this.subFeature = subFeature;
    }

    protected List<BlockPos> getRootPositions(WorldGenLevel reader, ChunkGenerator generator, WorldgenRandom random, ChunkPos generatingChunk, MultiChunkFeatureConfig config) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(1);
        for (int i = -config.maxChunksToRoot; i < config.maxChunksToRoot; ++i) {
            for (int j = -config.maxChunksToRoot; j < config.maxChunksToRoot; ++j) {
                ChunkPos currentChunk = new ChunkPos(generatingChunk.f_45578_ + i, generatingChunk.f_45579_ + j);
                random.m_190058_(reader.m_7328_(), currentChunk.f_45578_, currentChunk.f_45579_, config.featureSeedSalt);
                if (random.nextInt(config.chanceToGenerate) != 0) continue;
                result.add(currentChunk.m_45615_().m_142082_(random.nextInt(15), Math.min(generator.m_6331_(), config.minGenerationHeight + random.nextInt(Math.max(0, config.maxGenerationHeight - config.minGenerationHeight))), random.nextInt(15)));
            }
        }
        return result;
    }

    public boolean m_142674_(FeaturePlaceContext<MultiChunkFeatureConfig> context) {
        BlockPos pos = context.m_159777_();
        for (Holder biome : context.m_159775_().m_62218_().m_183399_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 1, context.m_159775_().m_183403_())) {
            ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)((Biome)biome.m_203334_()).getRegistryName());
            if (!BiomeUtil.containsType((ResourceKey<Biome>)biomeKey, ((MultiChunkFeatureConfig)context.m_159778_()).biomeTypeBlacklist)) continue;
            return false;
        }
        ChunkPos generatingChunk = new ChunkPos(pos);
        List<BlockPos> rootPositions = this.getRootPositions(context.m_159774_(), context.m_159775_(), (WorldgenRandom)context.m_159776_(), generatingChunk, (MultiChunkFeatureConfig)context.m_159778_());
        if (rootPositions.isEmpty()) {
            return false;
        }
        boolean generatedAny = false;
        for (BlockPos rootPosition : rootPositions) {
            if (!this.subFeature.place(context.m_159774_(), context.m_159775_(), context.m_159776_(), rootPosition, Math3DUtil.bounds(generatingChunk, context.m_159775_().m_6331_()), (MultiChunkFeatureConfig)context.m_159778_())) continue;
            generatedAny = true;
        }
        return generatedAny;
    }
}

