/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.tool;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FamiliarRingItem
extends Item {
    public FamiliarRingItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41784_().m_128471_("occupied")) {
            tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip", new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
        }
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        IFamiliar familiar;
        if (!playerIn.f_19853_.f_46443_ && target instanceof IFamiliar && ((familiar = (IFamiliar)target).getFamiliarOwner() == playerIn || familiar.getFamiliarOwner() == null) && FamiliarRingItem.getCurio(stack).captureFamiliar(playerIn.f_19853_, familiar)) {
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.CAPTURE);
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("occupied", true);
            ItemNBTUtil.setBoundSpiritName(stack, familiar.getFamiliarEntity().m_5446_().getString());
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43723_().m_21120_(pContext.m_43724_());
        if (!pContext.m_43723_().f_19853_.f_46443_ && FamiliarRingItem.getCurio(stack).releaseFamiliar(pContext.m_43723_(), pContext.m_43725_())) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("occupied", false);
            return InteractionResult.m_19078_((boolean)pContext.m_43723_().f_19853_.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    private static Curio getCurio(ItemStack stack) {
        ICurio curio = (ICurio)stack.getCapability(CuriosCapability.ITEM).orElse(null);
        if (curio != null && curio instanceof Curio) {
            return (Curio)curio;
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new Provider(stack);
    }

    public static IFamiliar getFamiliar(ItemStack stack, Level level) {
        Curio curio = FamiliarRingItem.getCurio(stack);
        return curio == null ? null : curio.getFamiliar(level);
    }

    private static class Curio
    implements ICurio,
    INBTSerializable<CompoundTag> {
        private final ItemStack stack;
        private IFamiliar familiar;
        private CompoundTag nbt;

        private Curio(ItemStack stack) {
            this.stack = stack;
        }

        private boolean captureFamiliar(Level level, IFamiliar familiar) {
            if (this.getFamiliar(level) != null) {
                return false;
            }
            familiar.getFamiliarEntity().onRemovedFromWorld();
            this.setFamiliar(familiar);
            this.getFamiliar(level).getFamiliarEntity().m_8127_();
            this.getFamiliar(level).getFamiliarEntity().m_20153_();
            this.getFamiliar(level).getFamiliarEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }

        private boolean releaseFamiliar(Player player, Level level) {
            if (this.getFamiliar(level) != null && !this.getFamiliar(level).getFamiliarEntity().isAddedToWorld()) {
                EntityType.m_20645_((CompoundTag)this.getFamiliar(level).getFamiliarEntity().serializeNBT(), (Level)level, e -> {
                    e.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    ((IFamiliar)e).setFamiliarOwner((LivingEntity)player);
                    level.m_7967_(e);
                    return e;
                });
                this.setFamiliar(null);
                return true;
            }
            return false;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            Level level = slotContext.entity().f_19853_;
            IFamiliar familiar = this.getFamiliar(level);
            if (familiar != null) {
                if (!familiar.getFamiliarEntity().isAddedToWorld()) {
                    familiar.getFamiliarEntity().f_19853_ = level;
                }
                if (familiar.getFamiliarOwner() != slotContext.entity()) {
                    return;
                }
                if (!level.f_46443_ && slotContext.entity().f_19797_ % 20 == 0 && familiar.isEffectEnabled(slotContext.entity())) {
                    for (MobEffectInstance effect : familiar.getFamiliarEffects()) {
                        familiar.getFamiliarOwner().m_7292_(effect);
                    }
                }
                familiar.curioTick(slotContext.entity());
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            compound.m_128379_("hasFamiliar", this.familiar != null || this.nbt != null);
            if (this.familiar != null) {
                compound.m_128365_("familiar", (Tag)this.familiar.getFamiliarEntity().serializeNBT());
            } else if (this.nbt != null) {
                compound.m_128365_("familiar", (Tag)this.nbt);
            }
            return compound;
        }

        public void deserializeNBT(CompoundTag compound) {
            if (compound.m_128471_("hasFamiliar")) {
                this.nbt = compound.m_128469_("familiar");
            }
        }

        private IFamiliar getFamiliar(Level level) {
            if (this.familiar != null) {
                return this.familiar;
            }
            if (this.nbt != null) {
                this.familiar = (IFamiliar)EntityType.m_20645_((CompoundTag)this.nbt, (Level)level, Function.identity());
                this.nbt = null;
            }
            return this.familiar;
        }

        private void setFamiliar(IFamiliar familiar) {
            this.familiar = familiar;
            this.nbt = null;
        }
    }

    private static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final ItemStack stack;
        private Curio curio;
        private final LazyOptional<ICurio> instance = LazyOptional.of(this::get);

        public Provider(ItemStack stack) {
            this.stack = stack;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.instance);
        }

        public CompoundTag serializeNBT() {
            return this.get().serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.get().deserializeNBT(nbt);
        }

        private Curio get() {
            if (this.curio == null) {
                this.curio = new Curio(this.stack);
            }
            return this.curio;
        }
    }
}

