/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.LumberjackJob;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FellTreesGoal
extends Goal {
    public static final int WORKAREA_EMPTY_REFRESH_TIME = 300;
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;
    protected BlockPos moveTarget = null;
    protected int breakingTime;
    protected int previousBreakProgress;
    protected boolean isTargetTree;
    protected long lastWorkareaEmptyTime;
    protected boolean shouldUseLumberjackDimensions;

    public FellTreesGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public static boolean isTreeSoil(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(OccultismTags.TREE_SOIL);
    }

    public static final boolean isLog(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13106_);
    }

    public static final boolean isLeaf(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60734_() instanceof LeavesBlock || blockState.m_204336_(BlockTags.f_13035_);
    }

    public boolean shouldUseLumberjackDimensions() {
        return this.shouldUseLumberjackDimensions;
    }

    public boolean m_8036_() {
        if (!this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean m_8045_() {
        return this.targetBlock != null && this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public void m_8041_() {
        this.shouldUseLumberjackDimensions = false;
        this.entity.m_6210_();
        this.entity.m_21573_().m_26573_();
        this.targetBlock = null;
        this.moveTarget = null;
    }

    public void m_8037_() {
        if (this.targetBlock != null) {
            this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_7864_(this.moveTarget, 0), 1.0);
            if (Occultism.DEBUG.debugAI) {
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageSelectBlock(this.targetBlock, 5000, 0xFFFFFF));
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageSelectBlock(this.moveTarget, 5000, 65280));
            }
            if (FellTreesGoal.isLog(this.entity.f_19853_, this.targetBlock)) {
                double distance = this.entity.m_20182_().m_82554_(Math3DUtil.center(this.moveTarget));
                if (distance < 2.5) {
                    if (distance < 1.0) {
                        this.entity.m_20334_(0.0, 0.0, 0.0);
                        this.entity.m_21573_().m_26573_();
                    }
                    if (this.isTargetTree || this.isTree(this.targetBlock)) {
                        this.isTargetTree = true;
                        this.updateBreakBlock();
                    } else {
                        this.isTargetTree = false;
                        this.entity.getJob().map(j -> (LumberjackJob)j).ifPresent(j -> j.getIgnoredTrees().add(this.targetBlock));
                        this.resetTarget();
                    }
                }
            } else {
                this.m_8041_();
            }
        }
    }

    public void updateBreakBlock() {
        ++this.breakingTime;
        this.entity.m_6674_(InteractionHand.MAIN_HAND);
        int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
        if (this.breakingTime % 10 == 0) {
            this.entity.m_5496_(SoundEvents.f_12634_, 1.0f, 1.0f);
            this.entity.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f);
        }
        if (i != this.previousBreakProgress) {
            this.entity.f_19853_.m_6801_(this.entity.m_142049_(), this.targetBlock, i);
            this.previousBreakProgress = i;
        }
        if (this.breakingTime == 160) {
            this.entity.m_5496_(SoundEvents.f_12630_, 1.0f, 1.0f);
            this.breakingTime = 0;
            this.previousBreakProgress = -1;
            this.fellTree();
            this.entity.getJob().map(j -> (LumberjackJob)j).ifPresent(j -> j.setLastFelledTree(this.targetBlock));
            this.targetBlock = null;
            this.m_8041_();
        }
    }

    private void resetTarget() {
        int workAreaSize;
        this.isTargetTree = false;
        this.shouldUseLumberjackDimensions = true;
        Level level = this.entity.f_19853_;
        if (level.m_46467_() - this.lastWorkareaEmptyTime < 300L) {
            return;
        }
        Set ignoredTrees = this.entity.getJob().map(j -> (LumberjackJob)j).map(LumberjackJob::getIgnoredTrees).orElse(new HashSet());
        BlockPos workAreaCenter = this.entity.getWorkAreaCenter();
        Stream<BlockPos> stream = BlockPos.m_121990_((BlockPos)workAreaCenter.m_142082_(-(workAreaSize = this.entity.getWorkAreaSize().getValue()), -workAreaSize / 2, -workAreaSize), (BlockPos)workAreaCenter.m_142082_(workAreaSize, workAreaSize / 2, workAreaSize)).map(BlockPos::m_7949_);
        List potentialStumps = stream.filter(pos -> FellTreesGoal.isLog(level, pos) && FellTreesGoal.isTreeSoil(level, pos.m_7495_()) && !ignoredTrees.contains(pos)).collect(Collectors.toList());
        if (!potentialStumps.isEmpty()) {
            potentialStumps.sort(this.targetSorter);
            this.targetBlock = (BlockPos)potentialStumps.get(0);
            this.moveTarget = null;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos pos2 = this.targetBlock.m_142300_(facing);
                if (!this.entity.f_19853_.m_46859_(pos2)) continue;
                this.moveTarget = pos2;
                break;
            }
            if (this.moveTarget == null) {
                this.targetBlock = null;
                this.shouldUseLumberjackDimensions = false;
            }
        } else {
            this.lastWorkareaEmptyTime = level.m_46467_();
            this.moveTarget = null;
            this.targetBlock = null;
            this.shouldUseLumberjackDimensions = false;
        }
        this.entity.m_6210_();
    }

    private boolean isTree(BlockPos potentialStump) {
        if (FellTreesGoal.isLog(this.entity.f_19853_, potentialStump)) {
            BlockPos topOfTree = new BlockPos((Vec3i)potentialStump);
            while (!this.entity.f_19853_.m_46859_(topOfTree.m_7494_()) && topOfTree.m_123342_() < this.entity.f_19853_.m_151558_()) {
                topOfTree = topOfTree.m_7494_();
            }
            if (FellTreesGoal.isLeaf(this.entity.f_19853_, topOfTree)) {
                BlockPos logPos = this.getStump(topOfTree);
                return FellTreesGoal.isLog(this.entity.f_19853_, logPos);
            }
        }
        return false;
    }

    private BlockPos getStump(BlockPos log) {
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)log.m_142082_(-4, -4, -4), (BlockPos)log.m_142082_(4, 0, 4)).map(BlockPos::m_7949_).collect(Collectors.toList())) {
            if (!FellTreesGoal.isLog(this.entity.f_19853_, pos.m_7495_()) && !FellTreesGoal.isLeaf(this.entity.f_19853_, pos.m_7495_())) continue;
            return this.getStump(pos.m_7495_());
        }
        return log;
    }

    private void fellTree() {
        Level level = this.entity.f_19853_;
        BlockPos base = new BlockPos((Vec3i)this.targetBlock);
        ArrayDeque<BlockPos> blocks = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        blocks.add(base);
        while (!blocks.isEmpty()) {
            BlockPos pos2;
            BlockPos pos = (BlockPos)blocks.remove();
            if (!visited.add(pos) || !FellTreesGoal.isLog(level, pos)) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                pos2 = pos.m_142300_(facing);
                if (visited.contains(pos2)) continue;
                blocks.add(pos2);
            }
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    pos2 = pos.m_142082_(-1 + x, 1, -1 + z);
                    if (visited.contains(pos2)) continue;
                    blocks.add(pos2);
                }
            }
            level.m_46961_(pos, true);
        }
    }
}

