/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.blockentity;

import com.github.klikli_dev.occultism.client.model.tile.DimensionalMatrixModel;
import com.github.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoBlockRenderer;

public class StorageControllerGeoRenderer
extends GeoBlockRenderer<StorageControllerBlockEntity> {
    private final AnimatedGeoModel<StorageControllerBlockEntity> modelProvider;

    public StorageControllerGeoRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        this(rendererDispatcherIn, new DimensionalMatrixModel());
    }

    public StorageControllerGeoRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn, AnimatedGeoModel<StorageControllerBlockEntity> modelProvider) {
        super(rendererDispatcherIn, modelProvider);
        this.modelProvider = modelProvider;
    }

    public void render(StorageControllerBlockEntity tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)tile));
        this.modelProvider.setLivingAnimations((Object)tile, this.getUniqueID(tile));
        stack.m_85836_();
        stack.m_85837_(0.5, 1.25, 0.5);
        long systemTime = System.currentTimeMillis();
        float angle = systemTime / 16L % 360L;
        stack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation(tile));
        Color renderColor = this.getRenderColor(tile, partialTicks, stack, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(tile, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation(tile));
        this.render(model, tile, partialTicks, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.f_118083_, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        stack.m_85849_();
    }

    public RenderType getRenderType(StorageControllerBlockEntity animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110470_((ResourceLocation)this.modelProvider.getTextureLocation((Object)animatable));
    }

    public Color getRenderColor(StorageControllerBlockEntity animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn) {
        long systemTime = System.currentTimeMillis();
        double systemTimeRadSin8 = Math.sin(Math.toRadians((float)systemTime / 8.0f));
        long colorScale = 100L - Math.abs(systemTime / 16L / 2L % 160L - 80L);
        float saturation = (float)systemTimeRadSin8 * 0.5f + 0.5f;
        return Color.ofHSB((float)(0.01f * (float)colorScale), (float)saturation, (float)(0.01f * (float)colorScale));
    }
}

