/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.ChunkLoaderCartEntity;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import com.alc.moreminecarts.tile_entities.LockingRailTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MinecartLoaderTile
extends AbstractCommonLoader {
    public MinecartLoaderTile(BlockPos pos, BlockState state) {
        super(MMReferences.minecart_loader_te, pos, state);
        this.last_redstone_output = !this.redstone_output;
    }

    @Override
    public boolean getIsUnloader() {
        return false;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        this.m_6596_();
        return new MinecartUnLoaderContainer(i, inventory, this, this.dataAccess, this.m_58899_());
    }

    protected AbstractContainerMenu m_6555_(int p_213906_1_, Inventory p_213906_2_) {
        return null;
    }

    public static void doTick(Level level, BlockPos pos, BlockState state, MinecartLoaderTile ent) {
        ent.tick();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (!this.isOnCooldown()) {
                int new_comparator_output_value;
                List<AbstractMinecart> minecarts = this.getLoadableMinecartsInRange();
                float criteria_total = 0.0f;
                for (AbstractMinecart minecart : minecarts) {
                    LazyOptional tankCapability = minecart.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                    LazyOptional energyCapability = minecart.getCapability(CapabilityEnergy.ENERGY);
                    if (tankCapability.isPresent()) {
                        IFluidHandler fluid_handler = (IFluidHandler)tankCapability.orElse(null);
                        criteria_total += this.doFluidLoads(fluid_handler);
                        continue;
                    }
                    if (energyCapability.isPresent()) {
                        IEnergyStorage energy_storage = (IEnergyStorage)energyCapability.orElse(null);
                        criteria_total += this.doElectricLoads(energy_storage);
                        continue;
                    }
                    if (minecart instanceof AbstractMinecartContainer) {
                        criteria_total += this.doMinecartLoads((AbstractMinecartContainer)minecart);
                        continue;
                    }
                    if (!(minecart instanceof MinecartFurnace)) continue;
                    criteria_total += this.doFuranceCartLoads((MinecartFurnace)minecart);
                }
                criteria_total = minecarts.size() == 0 ? 0.0f : (criteria_total /= (float)minecarts.size());
                if (this.comparator_output != AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
                    criteria_total = (float)Math.floor(criteria_total);
                }
                if ((new_comparator_output_value = (int)(criteria_total * 15.0f)) != this.comparator_output_value || this.last_redstone_output != this.redstone_output) {
                    this.comparator_output_value = new_comparator_output_value;
                    this.last_redstone_output = this.redstone_output;
                    this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
                    this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
                }
            } else {
                this.decCooldown();
            }
            if (this.changed_flag) {
                this.m_6596_();
                this.changed_flag = false;
            }
        }
    }

    public float doFluidLoads(IFluidHandler minecart_handler) {
        boolean changed = false;
        IFluidHandler our_fluid_handler = (IFluidHandler)this.fluid_handler.orElse(null);
        FluidStack our_fluid_stack = our_fluid_handler.getFluidInTank(0);
        float fluid_content_proportion = 0.0f;
        for (int i = 0; i < minecart_handler.getTanks(); ++i) {
            if (minecart_handler.getTankCapacity(i) > 0) {
                fluid_content_proportion += (float)minecart_handler.getFluidInTank(i).getAmount() / (float)minecart_handler.getTankCapacity(i);
            }
            if (our_fluid_stack.getAmount() <= (this.leave_one_in_stack ? 1 : 0)) continue;
            boolean did_load = false;
            if (minecart_handler.isFluidValid(i, our_fluid_stack)) {
                FluidStack add_to_stack = minecart_handler.getFluidInTank(i);
                if (add_to_stack.isEmpty()) {
                    FluidStack new_stack = our_fluid_stack.copy();
                    int transfer_amount = Math.min(1000, new_stack.getAmount());
                    new_stack.setAmount(transfer_amount);
                    minecart_handler.fill(new_stack, IFluidHandler.FluidAction.EXECUTE);
                    our_fluid_stack.shrink(transfer_amount);
                    did_load = true;
                } else if (add_to_stack.isFluidEqual(our_fluid_stack)) {
                    int true_count = our_fluid_stack.getAmount() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = minecart_handler.getTankCapacity(i) - add_to_stack.getAmount();
                    int transfer = Math.min(1000, Math.min(true_count, to_fill));
                    FluidStack adding_stack = add_to_stack.copy();
                    adding_stack.setAmount(transfer);
                    minecart_handler.fill(adding_stack, IFluidHandler.FluidAction.EXECUTE);
                    our_fluid_stack.shrink(transfer);
                    boolean bl = did_load = transfer > 0;
                }
            }
            if (!did_load) continue;
            changed = true;
            break;
        }
        if (minecart_handler.getTanks() > 0) {
            fluid_content_proportion /= (float)minecart_handler.getTanks();
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        return fluid_content_proportion;
    }

    public float doElectricLoads(IEnergyStorage minecart_handler) {
        boolean changed = false;
        IEnergyStorage our_handler = (IEnergyStorage)this.energy_handler.orElse(null);
        if (minecart_handler.canReceive()) {
            int true_count = our_handler.getEnergyStored() - (this.leave_one_in_stack ? 1 : 0);
            int to_fill = minecart_handler.getMaxEnergyStored() - minecart_handler.getEnergyStored();
            int transfer = Math.min(1000, Math.min(true_count, to_fill));
            minecart_handler.receiveEnergy(transfer, false);
            our_handler.extractEnergy(transfer, false);
            boolean bl = changed = transfer > 0;
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        return (float)minecart_handler.getEnergyStored() / (float)minecart_handler.getMaxEnergyStored();
    }

    public float doMinecartLoads(AbstractMinecartContainer minecart) {
        boolean changed = false;
        block0: for (ItemStack stack : this.items) {
            if (stack.m_41619_() || this.leave_one_in_stack && stack.m_41613_() == 1) continue;
            for (int i = 0; i < minecart.m_6643_() && !stack.m_41619_(); ++i) {
                boolean did_load = false;
                if (minecart.m_7013_(i, stack)) {
                    ItemStack add_to_stack = minecart.m_8020_(i);
                    if (add_to_stack.m_41619_()) {
                        ItemStack new_stack = stack.m_41777_();
                        int transfer_amount = Math.min(8, new_stack.m_41613_());
                        new_stack.m_41764_(transfer_amount);
                        minecart.m_6836_(i, new_stack);
                        stack.m_41774_(transfer_amount);
                        did_load = true;
                    } else if (MinecartLoaderTile.canMergeItems(add_to_stack, stack)) {
                        int true_count = stack.m_41613_() - (this.leave_one_in_stack ? 1 : 0);
                        int to_fill = add_to_stack.m_41741_() - add_to_stack.m_41613_();
                        int transfer = Math.min(8, Math.min(true_count, to_fill));
                        stack.m_41774_(transfer);
                        add_to_stack.m_41769_(transfer);
                        boolean bl = did_load = transfer > 0;
                    }
                }
                if (!did_load) continue;
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (minecart instanceof ChunkLoaderCartEntity && this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
            return (float)((ChunkLoaderCartEntity)minecart).getComparatorSignal() / 15.0f;
        }
        return (float)AbstractContainerMenu.m_38938_((Container)minecart) / 15.0f;
    }

    public float doFuranceCartLoads(MinecartFurnace minecart) {
        boolean changed = false;
        BlockEntity te_at_minecart = this.f_58857_.m_7702_(minecart.getCurrentRailPosition());
        if (te_at_minecart instanceof LockingRailTile && ((LockingRailTile)te_at_minecart).locked_minecart == minecart) {
            LockingRailTile locking_rail_tile = (LockingRailTile)te_at_minecart;
            if (locking_rail_tile.saved_fuel + 3600 <= 32000) {
                for (ItemStack stack : this.items) {
                    if (!Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_}).test(stack) || this.leave_one_in_stack && stack.m_41613_() == 1) continue;
                    stack.m_41774_(1);
                    locking_rail_tile.saved_fuel += 3600;
                    changed = true;
                }
            }
        } else {
            if (minecart.f_38548_ + 3600 <= 32000) {
                for (ItemStack stack : this.items) {
                    if (!Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_}).test(stack) || this.leave_one_in_stack && stack.m_41613_() == 1) continue;
                    stack.m_41774_(1);
                    minecart.f_38548_ += 3600;
                    changed = true;
                }
            }
            if (minecart.f_38545_ == 0.0 && minecart.f_38546_ == 0.0) {
                minecart.f_38545_ = minecart.m_20184_().f_82479_;
                minecart.f_38546_ = minecart.m_20184_().f_82481_;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        float fullness = Math.min((float)minecart.f_38548_ / 28400.0f, 1.0f);
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            fullness = (float)Math.floor(fullness);
        }
        return fullness;
    }

    protected Component m_6820_() {
        return new TranslatableComponent("Minecart Loader");
    }
}

