/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.entities.CampfireCartEntity;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LockingRailTile
extends BlockEntity {
    public static String LOCKED_CART_PROPERTY = "locked_cart";
    public static String SAVED_FUEL_PROPERTY = "saved_fuel";
    public static String SAVED_PUSH_X_PROPERTY = "saved_push_x";
    public static String SAVED_PUSH_Z_PROPERTY = "saved_push_z";
    private final int FURNACE_CART_MAX_FUEL = 32000;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public int saved_fuel;
    public double saved_push_x;
    public double saved_push_z;
    public UUID locked_minecart_uuid;
    @Nullable
    public AbstractMinecart locked_minecart = null;

    public LockingRailTile(BlockPos pos, BlockState state) {
        super(MMReferences.locking_rail_te, pos, state);
    }

    public LockingRailTile(BlockPos pos, BlockState state, boolean is_powered) {
        super(is_powered ? MMReferences.powered_locking_rail_te : MMReferences.locking_rail_te, pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        if (this.locked_minecart != null) {
            compound.m_128362_(LOCKED_CART_PROPERTY, this.locked_minecart.m_142081_());
        }
        compound.m_128405_(SAVED_FUEL_PROPERTY, this.saved_fuel);
        compound.m_128347_(SAVED_PUSH_X_PROPERTY, this.saved_push_x);
        compound.m_128347_(SAVED_PUSH_Z_PROPERTY, this.saved_push_z);
    }

    public void m_142466_(CompoundTag compound) {
        try {
            this.locked_minecart_uuid = compound.m_128342_(LOCKED_CART_PROPERTY);
            this.saved_fuel = compound.m_128451_(SAVED_FUEL_PROPERTY);
            this.saved_push_x = compound.m_128451_(SAVED_PUSH_X_PROPERTY);
            this.saved_push_z = compound.m_128451_(SAVED_PUSH_Z_PROPERTY);
        }
        catch (NullPointerException e) {
            this.locked_minecart = null;
            this.saved_fuel = 0;
            this.saved_push_x = 0.0;
            this.saved_push_z = 0.0;
        }
        super.m_142466_(compound);
    }

    public void m_7651_() {
        if (!this.f_58857_.f_46443_) {
            this.lockOut();
        }
        super.m_7651_();
    }

    protected void lockIn(AbstractMinecart cart) {
        if (this.locked_minecart == cart) {
            return;
        }
        this.f_58857_.m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11745_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        this.locked_minecart = cart;
        this.locked_minecart.m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5);
        this.locked_minecart.m_20334_(0.0, 0.0, 0.0);
        if (this.locked_minecart instanceof MinecartFurnace) {
            this.saved_fuel = ((MinecartFurnace)this.locked_minecart).f_38548_;
            ((MinecartFurnace)this.locked_minecart).f_38548_ = 0;
            this.saved_push_x = ((MinecartFurnace)this.locked_minecart).f_38545_;
            this.saved_push_z = ((MinecartFurnace)this.locked_minecart).f_38546_;
        }
        if (this.locked_minecart instanceof CampfireCartEntity) {
            this.saved_fuel = ((CampfireCartEntity)this.locked_minecart).isMinecartPowered() ? 1 : 0;
            ((CampfireCartEntity)this.locked_minecart).setMinecartPowered(false);
            this.saved_push_x = ((CampfireCartEntity)this.locked_minecart).pushX;
            this.saved_push_z = ((CampfireCartEntity)this.locked_minecart).pushZ;
        }
    }

    protected void lockOut() {
        if (this.locked_minecart == null) {
            return;
        }
        this.f_58857_.m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11794_, SoundSource.BLOCKS, 0.0f, 0.5f, false);
        if (this.locked_minecart instanceof MinecartFurnace) {
            MinecartFurnace furnace_minecart = (MinecartFurnace)this.locked_minecart;
            int fuel = furnace_minecart.f_38548_;
            if ((fuel += this.saved_fuel) > 32000) {
                fuel = 32000;
            }
            furnace_minecart.f_38548_ = fuel;
            furnace_minecart.f_38545_ = this.saved_push_x;
            furnace_minecart.f_38546_ = this.saved_push_z;
        }
        if (this.locked_minecart instanceof CampfireCartEntity) {
            ((CampfireCartEntity)this.locked_minecart).setMinecartPowered(this.saved_fuel >= 1);
            ((CampfireCartEntity)this.locked_minecart).pushX = this.saved_push_x;
            ((CampfireCartEntity)this.locked_minecart).pushZ = this.saved_push_z;
        }
        this.locked_minecart = null;
    }

    public boolean updateLock(boolean locked) {
        List<AbstractMinecart> list;
        if (!(this.locked_minecart == null || locked && this.locked_minecart.m_6084_())) {
            this.lockOut();
            return true;
        }
        if (locked && this.locked_minecart == null && (list = this.findMinecarts(this.f_58857_, this.m_58899_(), AbstractMinecart.class, cart -> true)).size() > 0) {
            this.lockIn(list.get(0));
            return true;
        }
        return false;
    }

    protected <T extends AbstractMinecart> List<T> findMinecarts(Level worldIn, BlockPos pos, Class<T> cartType, @Nullable Predicate<Entity> filter) {
        return worldIn.m_6443_(cartType, this.getDectectionBox(pos), filter);
    }

    private AABB getDectectionBox(BlockPos pos) {
        double d0 = 0.2;
        return new AABB((double)pos.m_123341_() + 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.2, (double)(pos.m_123341_() + 1) - 0.2, (double)(pos.m_123342_() + 1) - 0.2, (double)(pos.m_123343_() + 1) - 0.2);
    }

    public int getComparatorSignal() {
        return this.locked_minecart == null ? 0 : 15;
    }

    public static void doTick(Level level, BlockPos pos, BlockState state, LockingRailTile ent) {
        if (level.f_46443_) {
            return;
        }
        if (ent.locked_minecart_uuid != null) {
            Entity locked_entity = ((ServerLevel)level).m_8791_(ent.locked_minecart_uuid);
            if (locked_entity instanceof AbstractMinecart) {
                ent.locked_minecart = (AbstractMinecart)locked_entity;
            } else {
                ent.saved_fuel = 0;
                ent.saved_push_x = 0.0;
                ent.saved_push_z = 0.0;
            }
            ent.locked_minecart_uuid = null;
        }
        if (ent.locked_minecart != null) {
            if (ent.locked_minecart.m_6084_()) {
                ent.locked_minecart.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                ent.locked_minecart.m_20334_(0.0, 0.0, 0.0);
            } else {
                ent.locked_minecart = null;
                level.m_46717_(pos, state.m_60734_());
            }
        }
    }
}

