/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.renderers;

import com.alc.moreminecarts.MoreMinecartsMod;
import com.alc.moreminecarts.entities.CouplerEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.model.LeashKnotModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Level;

public class CouplerRenderer
extends EntityRenderer<CouplerEntity> {
    private static final ResourceLocation LEASH_KNOT_TEXTURES = new ResourceLocation("minecraft:textures/entity/lead_knot.png");
    protected LeashKnotModel<CouplerEntity> leashKnotModel;

    public CouplerRenderer(EntityRendererProvider.Context p_174300_) {
        super(p_174300_);
        this.leashKnotModel = new LeashKnotModel(p_174300_.m_174023_(ModelLayers.f_171193_));
    }

    public void render(CouplerEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Entity vehicle1 = entityIn.getFirstVehicle();
        Entity vehicle2 = entityIn.getSecondVehicle();
        if (vehicle1 != null && vehicle2 != null) {
            MoreMinecartsMod.LOGGER.log(Level.WARN, "COUPLER RENDER");
            this.renderCoupler(entityIn.f_19853_, partialTicks, matrixStackIn, bufferIn, vehicle1, vehicle2);
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(CouplerEntity entity) {
        return LEASH_KNOT_TEXTURES;
    }

    public Vec3 getLerpedPosition(Entity entity, float partialTicks) {
        double d0 = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    private <E extends Entity> void renderCoupler(net.minecraft.world.level.Level world, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, Entity vehicle1, Entity vehicle2) {
        matrixStackIn.m_85836_();
        Vec3 vehicle1_pos = this.getLerpedPosition(vehicle1, partialTicks);
        Vec3 vehicle2_pos = this.getLerpedPosition(vehicle2, partialTicks);
        Vec3 from_pos = vehicle1_pos.m_82492_(0.0, vehicle1.m_142469_().m_82376_() / 2.0, 0.0);
        Vec3 to_pos = vehicle2_pos.m_82492_(0.0, vehicle2.m_142469_().m_82376_() / 2.0, 0.0);
        double d0 = (double)(vehicle1.m_146908_() * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 v1_lead_pos = vehicle1.m_7939_();
        double d1 = Math.cos(d0) * v1_lead_pos.f_82481_ + Math.sin(d0) * v1_lead_pos.f_82479_;
        double d2 = Math.sin(d0) * v1_lead_pos.f_82481_ - Math.cos(d0) * v1_lead_pos.f_82479_;
        double d3 = Mth.m_14139_((double)partialTicks, (double)vehicle1.f_19790_, (double)vehicle1.m_20182_().f_82479_) + d1;
        double d4 = Mth.m_14139_((double)partialTicks, (double)vehicle1.f_19791_, (double)vehicle1.m_20182_().f_82480_) + v1_lead_pos.f_82480_;
        double d5 = Mth.m_14139_((double)partialTicks, (double)vehicle1.f_19792_, (double)vehicle1.m_20182_().f_82481_) + d2;
        float dx = (float)(to_pos.f_82479_ - from_pos.f_82479_);
        float dy = (float)(to_pos.f_82480_ - from_pos.f_82480_);
        float dz = (float)(to_pos.f_82481_ - from_pos.f_82481_);
        matrixStackIn.m_85837_((double)(-dx / 2.0f), (double)(-dy / 2.0f), (double)(-dz / 2.0f));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_85861_();
        float dist = Mth.m_14195_((float)(dx * dx + dz * dz)) * 0.025f / 2.0f;
        float norm_z = dz * dist;
        float norm_x = dx * dist;
        BlockPos blockpos1 = new BlockPos(from_pos);
        BlockPos blockpos2 = new BlockPos(to_pos);
        int i = this.getBlockLightFake(vehicle1, blockpos1);
        int j = this.getBlockLightFake(vehicle2, blockpos2);
        int k = world.m_45517_(LightLayer.SKY, blockpos1);
        int l = world.m_45517_(LightLayer.SKY, blockpos2);
        CouplerRenderer.renderSide(ivertexbuilder, matrix4f, dx, dy, dz, i, j, k, l, 0.1f, 0.1f, norm_z, norm_x);
        matrixStackIn.m_85849_();
    }

    protected int getBlockLightFake(Entity entityIn, BlockPos partialTicks) {
        return entityIn.m_6060_() ? 15 : entityIn.f_19853_.m_45517_(LightLayer.BLOCK, partialTicks);
    }

    public static void renderSide(VertexConsumer builderIn, Matrix4f matrixIn, float p_229119_2_, float p_229119_3_, float p_229119_4_, int blockLight, int holderBlockLight, int skyLight, int holderSkyLight, float p_229119_9_, float p_229119_10_, float norm_z, float norm_x) {
        int i = 4;
        for (int j = 0; j < 4; ++j) {
            float f = (float)j / 3.0f;
            int k = (int)Mth.m_14179_((float)f, (float)blockLight, (float)holderBlockLight);
            int l = (int)Mth.m_14179_((float)f, (float)skyLight, (float)holderSkyLight);
            int i1 = LightTexture.m_109885_((int)k, (int)l);
            CouplerRenderer.addVertexPair(builderIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 4, j, false, norm_z, norm_x);
            CouplerRenderer.addVertexPair(builderIn, matrixIn, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 4, j + 1, true, norm_z, norm_x);
        }
    }

    public static void addVertexPair(VertexConsumer builderIn, Matrix4f matrixIn, int packedLight, float dx, float dy, float dz, float thickness, float y_width, int total, int index, boolean is_first, float norm_z, float norm_x) {
        float stress = Math.abs(dx * dx + dy * dy + dz * dz);
        stress = Math.max(0.0f, stress - 3.0f);
        float R = 0.1f + stress / 40.0f;
        float G = 0.15f;
        float B = 0.2f;
        float fraction_done = (float)index / (float)total;
        float center_x = dx * fraction_done;
        float center_y = dy * fraction_done;
        float center_z = dz * fraction_done;
        if (!is_first) {
            builderIn.m_85982_(matrixIn, center_x + norm_z, center_y + thickness - y_width, center_z - norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        }
        builderIn.m_85982_(matrixIn, center_x - norm_z, center_y + y_width, center_z + norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        if (is_first) {
            builderIn.m_85982_(matrixIn, center_x + norm_z, center_y + thickness - y_width, center_z - norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        }
    }

    public static void addVertexPairOpposite(VertexConsumer builderIn, Matrix4f matrixIn, int packedLight, float dx, float dy, float dz, float thickness, float y_width, int total, int index, boolean is_first, float norm_z, float norm_x) {
        float stress = Math.abs(dx * dx + dy * dy + dz * dz);
        stress = Math.max(0.0f, stress - 3.0f);
        float R = 0.1f + stress / 40.0f;
        float G = 0.15f;
        float B = 0.2f;
        float fraction_done = (float)index / (float)total;
        float center_x = dx * fraction_done;
        float center_y = dy * fraction_done;
        float center_z = dz * fraction_done;
        float magn = Mth.m_14195_((float)(dx * dx + dy * dy));
        float thickness_z = norm_z * thickness * 100.0f;
        float thickness_x = norm_x * thickness * 100.0f;
        if (!is_first) {
            builderIn.m_85982_(matrixIn, center_x + thickness_x / 2.0f + norm_z, center_y + thickness / 2.0f - y_width, center_z + thickness_z / 2.0f - norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        }
        builderIn.m_85982_(matrixIn, center_x - thickness_x / 2.0f - norm_z, center_y + thickness / 2.0f + y_width, center_z - thickness_z / 2.0f + norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        if (is_first) {
            builderIn.m_85982_(matrixIn, center_x + thickness_x / 2.0f + norm_z, center_y + thickness / 2.0f - y_width, center_z + thickness_z / 2.0f - norm_x).m_85950_(R, G, B, 1.0f).m_85969_(packedLight).m_5752_();
        }
    }
}

