/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMItemReferences;
import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.containers.TankCartContainer;
import com.alc.moreminecarts.entities.FlagCartEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;

public class TankCartEntity
extends AbstractMinecart
implements Container,
MenuProvider {
    private static final EntityDataAccessor<CompoundTag> FLUID_TAG = SynchedEntityData.m_135353_(FlagCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    boolean changed_flag;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TankCartEntity.this.m_142049_();
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
        }

        public int m_6499_() {
            return 1;
        }
    };
    LazyOptional<IFluidHandler> fluid_handler = LazyOptional.of(() -> new CartTank(40000));

    public TankCartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public TankCartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluid_handler.cast();
        }
        return super.getCapability(cap);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public void m_7617_(DamageSource source) {
        super.m_7617_(source);
        if (!source.m_19372_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)MMItemReferences.transport_tank);
        }
    }

    public BlockState m_6390_() {
        return (BlockState)MMReferences.piston_display_block.m_49966_().m_61124_((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(4));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_(this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_ + 0.5) <= 64.0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLUID_TAG, (Object)new CompoundTag());
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        FluidTank tank = (FluidTank)this.fluid_handler.resolve().get();
        tank.setFluid(tank.readFromNBT(compound).getFluid());
        this.changed_flag = true;
    }

    public FluidStack getFluidStack() {
        if (!this.f_19853_.f_46443_) {
            return ((IFluidHandler)this.fluid_handler.orElse(null)).getFluidInTank(0);
        }
        return ((FluidTank)this.fluid_handler.orElse(null)).readFromNBT((CompoundTag)this.f_19804_.m_135370_(FLUID_TAG)).getFluid();
    }

    public int getComparatorSignal() {
        return (int)Math.floor((double)((float)((FluidTank)this.fluid_handler.resolve().get()).getFluidAmount() / (float)((FluidTank)this.fluid_handler.resolve().get()).getCapacity()) * 15.0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inv, Player player) {
        return new TankCartContainer(i, this.f_19853_, this, inv, player);
    }

    public InteractionResult m_6096_(Player p_184230_1_, InteractionHand p_184230_2_) {
        InteractionResult ret = super.m_6096_(p_184230_1_, p_184230_2_);
        if (ret.m_19077_()) {
            return ret;
        }
        p_184230_1_.m_5893_((MenuProvider)this);
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.changed_flag && !this.f_19853_.f_46443_) {
            this.updateSynchedData();
            this.changed_flag = false;
        }
    }

    protected void updateSynchedData() {
        CompoundTag compound = new CompoundTag();
        ((FluidTank)this.fluid_handler.orElse(null)).writeToNBT(compound);
        this.f_19804_.m_135381_(FLUID_TAG, (Object)compound);
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int p_18941_) {
        return null;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return null;
    }

    public ItemStack m_8016_(int p_18951_) {
        return null;
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
    }

    public void m_6596_() {
    }

    public void m_6211_() {
    }

    public class CartTank
    extends FluidTank {
        public CartTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (TankCartEntity.this.f_19853_ != null && !TankCartEntity.this.f_19853_.f_46443_) {
                TankCartEntity.this.updateSynchedData();
            }
        }
    }
}

