/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.MMReferences;
import com.alc.moreminecarts.blocks.PistonDisplayBlock;
import com.alc.moreminecarts.blocks.utility_rails.ArithmeticRailBlock;
import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.misc.FlagUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;

public class FlagCartEntity
extends AbstractMinecartContainer {
    public static String SELECTED_SLOT_PROPERTY = "selected_slot";
    public static String DISCLUDED_SLOTS_PROPERTY = "discluded_slots";
    private static final EntityDataAccessor<Integer> DISPLAY_TYPE = SynchedEntityData.m_135353_(FlagCartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int selected_slot = 0;
    public int discluded_slots = 0;
    public BlockPos old_block_pos;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FlagCartEntity.this.selected_slot;
                }
                case 1: {
                    return FlagCartEntity.this.discluded_slots;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int set_to) {
            switch (index) {
                case 0: {
                    FlagCartEntity.this.selected_slot = set_to;
                    break;
                }
                case 1: {
                    FlagCartEntity.this.discluded_slots = set_to;
                    FlagCartEntity.this.selected_slot = Math.min(8 - FlagCartEntity.this.discluded_slots, FlagCartEntity.this.selected_slot);
                    break;
                }
            }
            FlagCartEntity.this.updateDisplayType();
        }

        public int m_6499_() {
            return 2;
        }
    };

    public FlagCartEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public FlagCartEntity(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public void m_7617_(DamageSource source) {
        super.m_7617_(source);
        if (!source.m_19372_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)Items.f_42719_);
            this.m_19998_((ItemLike)Items.f_42351_);
        }
    }

    protected AbstractContainerMenu m_7402_(int i, Inventory inv) {
        return new FlagCartContainer(i, this.f_19853_, this, inv, inv.f_35978_);
    }

    public BlockState m_6390_() {
        int raw_display = 6 + this.getDisplayType();
        return (BlockState)MMReferences.piston_display_block.m_49966_().m_61124_((Property)PistonDisplayBlock.VARIANT, (Comparable)Integer.valueOf(raw_display));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6025_(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        if (!this.f_19853_.f_46443_) {
            this.selected_slot = 0;
        }
        this.updateDisplayType();
    }

    public int m_6643_() {
        return 9;
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        ItemStack ret = super.m_7407_(p_70298_1_, p_70298_2_);
        this.updateDisplayType();
        return ret;
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        super.m_6836_(p_70299_1_, p_70299_2_);
        this.updateDisplayType();
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_(this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + 0.5, this.m_20182_().f_82481_ + 0.5) <= 64.0;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(SELECTED_SLOT_PROPERTY, this.selected_slot);
        compound.m_128405_(DISCLUDED_SLOTS_PROPERTY, this.discluded_slots);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.selected_slot = compound.m_128451_(SELECTED_SLOT_PROPERTY);
        this.discluded_slots = compound.m_128451_(DISCLUDED_SLOTS_PROPERTY);
        this.updateDisplayType();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISPLAY_TYPE, (Object)0);
    }

    public Item getSelectedFlag() {
        return this.m_8020_(this.selected_slot).m_41720_();
    }

    public void cycleFlag(ArithmeticRailBlock.SignalEffect effect) {
        boolean is_decrement = effect.isNegative();
        if (effect.isShift()) {
            this.selected_slot = FlagUtil.getNextSelectedSlot(this.selected_slot, this.discluded_slots, is_decrement);
        } else {
            if (!is_decrement && this.discluded_slots >= 8) {
                return;
            }
            if (is_decrement && this.discluded_slots <= 0) {
                return;
            }
            this.discluded_slots += is_decrement ? -1 : 1;
            this.selected_slot = Math.min(8 - this.discluded_slots, this.selected_slot);
        }
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12015_, SoundSource.BLOCKS, 0.5f, 1.0f, true);
        this.updateDisplayType();
    }

    public int getDisplayType() {
        return (Integer)this.f_19804_.m_135370_(DISPLAY_TYPE);
    }

    public void updateDisplayType() {
        if (!this.f_19853_.f_46443_) {
            Item this_item = this.m_8020_(this.selected_slot).m_41720_();
            int full_display = 0;
            this.f_19804_.m_135381_(DISPLAY_TYPE, (Object)(full_display += FlagUtil.getFlagColorValue(this_item)));
        }
    }

    public void m_8119_() {
        BlockPos new_block_pos;
        if (this.old_block_pos == null) {
            this.old_block_pos = this.m_142538_();
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.old_block_pos.equals((Object)(new_block_pos = this.m_142538_()))) {
            BlockState new_blockstate = this.f_19853_.m_8055_(new_block_pos);
            if (new_blockstate.m_60734_() == MMReferences.arithmetic_rail && ((Boolean)new_blockstate.m_61143_((Property)ArithmeticRailBlock.POWERED)).booleanValue()) {
                this.cycleFlag((ArithmeticRailBlock.SignalEffect)((Object)new_blockstate.m_61143_((Property)ArithmeticRailBlock.EFFECT)));
            }
            this.old_block_pos = new_block_pos;
        }
    }
}

