/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ItemBaseContainerScreen;
import com.supermartijn642.core.gui.ObjectBaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import com.supermartijn642.simplemagnets.gui.CheckBox;
import com.supermartijn642.simplemagnets.gui.DurabilityButton;
import com.supermartijn642.simplemagnets.gui.MagnetContainer;
import com.supermartijn642.simplemagnets.gui.PlusMinusButton;
import com.supermartijn642.simplemagnets.gui.WhitelistButton;
import com.supermartijn642.simplemagnets.packets.magnet.PacketDecreaseItemRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketDecreaseXpRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketIncreaseItemRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketIncreaseXpRange;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleItems;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetDurability;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleMagnetWhitelist;
import com.supermartijn642.simplemagnets.packets.magnet.PacketToggleXp;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class MagnetContainerScreen
extends ItemBaseContainerScreen<MagnetContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("simplemagnets", "textures/screen.png");
    private CheckBox itemCheckbox;
    private PlusMinusButton leftItemButton;
    private PlusMinusButton rightItemButton;
    private CheckBox xpCheckbox;
    private PlusMinusButton leftXpButton;
    private PlusMinusButton rightXpButton;
    private WhitelistButton whitelistButton;
    private DurabilityButton durabilityButton;
    private int itemRange = SMConfig.advancedMagnetRange.get();
    private int xpRange = SMConfig.advancedMagnetRange.get();

    public MagnetContainerScreen(MagnetContainer container, Inventory inv, Component title) {
        super((ObjectBaseContainer)container, title);
    }

    protected int sizeX(ItemStack stack) {
        return 224;
    }

    protected int sizeY(ItemStack stack) {
        return 196;
    }

    protected void addWidgets(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        this.itemCheckbox = (CheckBox)this.addWidget((Widget)new CheckBox(11, 38, checked -> checked != false ? "gui.advancedmagnet.items.on" : "gui.advancedmagnet.items.off", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleItems())));
        this.itemCheckbox.update(!tag.m_128441_("items") || !tag.m_128471_("items"));
        this.leftItemButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(54, 38, true, "gui.advancedmagnet.items.decrease", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketDecreaseItemRange())));
        this.rightItemButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(88, 38, false, "gui.advancedmagnet.items.increase", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketIncreaseItemRange())));
        this.xpCheckbox = (CheckBox)this.addWidget((Widget)new CheckBox(119, 38, checked -> checked != false ? "gui.advancedmagnet.xp.on" : "gui.advancedmagnet.xp.off", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleXp())));
        this.xpCheckbox.update(!tag.m_128441_("xp") || !tag.m_128471_("xp"));
        this.leftXpButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(162, 38, true, "gui.advancedmagnet.xp.decrease", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketDecreaseXpRange())));
        this.rightXpButton = (PlusMinusButton)this.addWidget((Widget)new PlusMinusButton(196, 38, false, "gui.advancedmagnet.xp.increase", () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketIncreaseXpRange())));
        this.whitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, 78, () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleMagnetWhitelist())));
        this.whitelistButton.update(tag.m_128441_("whitelist") && tag.m_128471_("whitelist"));
        this.durabilityButton = (DurabilityButton)this.addWidget((Widget)new DurabilityButton(197, 78, () -> SimpleMagnets.CHANNEL.sendToServer((BasePacket)new PacketToggleMagnetDurability())));
        this.durabilityButton.update(tag.m_128441_("filterDurability") && tag.m_128471_("filterDurability"));
    }

    protected void containerTick(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        this.itemRange = tag.m_128441_("itemRange") ? tag.m_128451_("itemRange") : SMConfig.advancedMagnetRange.get().intValue();
        this.xpRange = tag.m_128441_("xpRange") ? tag.m_128451_("xpRange") : SMConfig.advancedMagnetRange.get().intValue();
        boolean items = !tag.m_128441_("items") || !tag.m_128471_("items");
        this.itemCheckbox.update(items);
        this.leftItemButton.setActive(items && this.itemRange > SMConfig.advancedMagnetMinRange.get());
        this.rightItemButton.setActive(items && this.itemRange < SMConfig.advancedMagnetMaxRange.get());
        boolean experience = !tag.m_128441_("xp") || !tag.m_128471_("xp");
        this.xpCheckbox.update(experience);
        this.leftXpButton.setActive(experience && this.xpRange > SMConfig.advancedMagnetMinRange.get());
        this.rightXpButton.setActive(experience && this.xpRange < SMConfig.advancedMagnetMaxRange.get());
        this.whitelistButton.update(tag.m_128441_("whitelist") && tag.m_128471_("whitelist"));
        this.durabilityButton.update(tag.m_128441_("filterDurability") && tag.m_128471_("filterDurability"));
    }

    protected void renderBackground(PoseStack matrixStack, int mouseX, int mouseY, ItemStack object) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.f_97726_, (float)this.f_97727_);
    }

    protected void renderForeground(PoseStack matrixStack, int mouseX, int mouseY, ItemStack object) {
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (float)((float)this.f_97726_ / 2.0f), (float)6.0f, (int)0x404040);
        ScreenUtils.drawString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_169604_, (float)32.0f, (float)102.0f, (int)0x404040);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TextComponents.translation((String)"gui.advancedmagnet.items").get(), (float)58.0f, (float)24.0f, (int)0x404040);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TextComponents.translation((String)"gui.advancedmagnet.xp").get(), (float)166.0f, (float)24.0f, (int)0x404040);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TextComponents.translation((String)"gui.advancedmagnet.filter").get(), (float)112.0f, (float)68.0f, (int)0x404040);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TextComponents.number((int)this.itemRange).get(), (float)79.5f, (float)43.0f, (int)0x404040);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (Component)TextComponents.number((int)this.xpRange).get(), (float)187.5f, (float)43.0f, (int)0x404040);
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY, ItemStack stack) {
        if ((float)mouseX > 74.5f && (float)mouseX < 84.5f && mouseY > 38 && mouseY < 48) {
            this.m_96602_(matrixStack, (Component)TextComponents.translation((String)"gui.advancedmagnet.items.range", (Object[])new Object[]{this.itemRange}).get(), mouseX, mouseY);
        }
        if ((float)mouseX > 182.5f && (float)mouseX < 192.5f && mouseY > 38 && mouseY < 48) {
            this.m_96602_(matrixStack, (Component)TextComponents.translation((String)"gui.advancedmagnet.xp.range", (Object[])new Object[]{this.xpRange}).get(), mouseX, mouseY);
        }
    }
}

