/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.block.LootFabBlock;
import shadows.hostilenetworks.block.SimChamberBlock;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.gui.LootFabContainer;
import shadows.hostilenetworks.gui.SimChamberContainer;
import shadows.hostilenetworks.item.BlankDataModelItem;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.hostilenetworks.tile.LootFabTileEntity;
import shadows.hostilenetworks.tile.SimChamberTileEntity;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;

@Mod(value="hostilenetworks")
public class HostileNetworks {
    public static final String MODID = "hostilenetworks";
    public static final String VERSION = ((ModContainer)ModList.get().getModContainerById("hostilenetworks").get()).getModInfo().getVersion().toString();
    public static final Logger LOGGER = LogManager.getLogger((String)"hostilenetworks");
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("hostilenetworks", "hostilenetworks")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final CreativeModeTab TAB = new CreativeModeTab("hostilenetworks"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Hostile.Blocks.SIM_CHAMBER);
        }
    };

    public HostileNetworks() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        HostileConfig.load();
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((Block)new SimChamberBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60953_(s -> 1).m_60913_(4.0f, 3000.0f).m_60955_()).setRegistryName("sim_chamber")));
        reg.register((IForgeRegistryEntry)((Block)new LootFabBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60953_(s -> 1).m_60913_(4.0f, 3000.0f).m_60955_()).setRegistryName("loot_fabricator")));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(SimChamberTileEntity::new, (Set)ImmutableSet.of((Object)Hostile.Blocks.SIM_CHAMBER), false, true).setRegistryName("sim_chamber")));
        reg.register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(LootFabTileEntity::new, (Set)ImmutableSet.of((Object)Hostile.Blocks.LOOT_FABRICATOR), false, true).setRegistryName("loot_fabricator")));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((Item)new DeepLearnerItem(new Item.Properties().m_41487_(1).m_41491_(TAB)).setRegistryName("deep_learner")));
        reg.register((IForgeRegistryEntry)((Item)new BlankDataModelItem(new Item.Properties().m_41487_(1).m_41491_(TAB)).setRegistryName("blank_data_model")));
        reg.register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(TAB)).setRegistryName("empty_prediction")));
        reg.register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(TAB)).setRegistryName("overworld_prediction")));
        reg.register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(TAB)).setRegistryName("nether_prediction")));
        reg.register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(TAB)).setRegistryName("end_prediction")));
        reg.register((IForgeRegistryEntry)((Item)new BlockItem(Hostile.Blocks.SIM_CHAMBER, new Item.Properties().m_41491_(TAB)).setRegistryName("sim_chamber")));
        reg.register((IForgeRegistryEntry)((Item)new BlockItem(Hostile.Blocks.LOOT_FABRICATOR, new Item.Properties().m_41491_(TAB)).setRegistryName("loot_fabricator")));
        reg.register((IForgeRegistryEntry)((Item)new DataModelItem(new Item.Properties().m_41487_(1).m_41491_(TAB)).setRegistryName("data_model")));
        reg.register((IForgeRegistryEntry)((Item)new MobPredictionItem(new Item.Properties().m_41491_(TAB)).setRegistryName("prediction")));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((MenuType)new MenuType((MenuType.MenuSupplier)((IContainerFactory)(id, inv, buf) -> new DeepLearnerContainer(id, inv, buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND))).setRegistryName("deep_learner")));
        reg.register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(SimChamberContainer::new).setRegistryName("sim_chamber")));
        reg.register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(LootFabContainer::new).setRegistryName("loot_fabricator")));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        LootSystem.defaultBlockTable((Block)Hostile.Blocks.LOOT_FABRICATOR);
        LootSystem.defaultBlockTable((Block)Hostile.Blocks.SIM_CHAMBER);
        DataModelManager.INSTANCE.registerToBus();
    }
}

