/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;

@Mod.EventBusSubscriber(modid="hostilenetworks")
public class HostileEvents {
    @SubscribeEvent
    public static void modelAttunement(PlayerInteractEvent.EntityInteractSpecific e) {
        Player player = e.getPlayer();
        ItemStack stack = player.m_21120_(e.getHand());
        if (stack.m_41720_() == Hostile.Items.BLANK_DATA_MODEL) {
            if (!player.f_19853_.f_46443_) {
                DataModel model = DataModelManager.INSTANCE.getForEntity(e.getTarget().m_6095_());
                if (model == null) {
                    MutableComponent msg = new TranslatableComponent("hostilenetworks.msg.no_model").m_130940_(ChatFormatting.RED);
                    player.m_6352_((Component)msg, Util.f_137441_);
                    return;
                }
                MutableComponent msg = new TranslatableComponent("hostilenetworks.msg.built", new Object[]{model.getName()}).m_130940_(ChatFormatting.GOLD);
                player.m_6352_((Component)msg, Util.f_137441_);
                ItemStack modelStack = new ItemStack((ItemLike)Hostile.Items.DATA_MODEL);
                DataModelItem.setStoredModel(modelStack, model);
                player.m_21008_(e.getHand(), modelStack);
            }
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void kill(LivingDeathEvent e) {
        Entity src = e.getSource().m_7639_();
        if (src instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)src;
            p.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() == Hostile.Items.DEEP_LEARNER).forEach(dl -> HostileEvents.updateModels(dl, e.getEntityLiving().m_6095_(), 0));
            if (p.m_21206_().m_41720_() == Hostile.Items.DEEP_LEARNER) {
                HostileEvents.updateModels(p.m_21206_(), e.getEntityLiving().m_6095_(), 0);
            }
        }
    }

    public static void updateModels(ItemStack learner, EntityType<?> type, int bonus) {
        ItemStackHandler handler = DeepLearnerItem.getItemHandler(learner);
        for (int i = 0; i < 4; ++i) {
            DataModel dModel;
            ItemStack model = handler.getStackInSlot(i);
            if (model.m_41619_() || (dModel = DataModelItem.getStoredModel(model)).getType() != type && !dModel.getSubtypes().contains(type)) continue;
            int data = DataModelItem.getData(model);
            ModelTier tier = ModelTier.getByData(dModel, data);
            DataModelItem.setData(model, data + dModel.getDataPerKill(tier) + bonus);
        }
        DeepLearnerItem.saveItems(learner, handler);
    }
}

