/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.gui.DeepLearnerScreen;
import shadows.hostilenetworks.gui.LootFabScreen;
import shadows.hostilenetworks.gui.SimChamberScreen;
import shadows.hostilenetworks.item.MobPredictionItem;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="hostilenetworks")
public class HostileClient {
    public static int clientTicks = 0;

    @SubscribeEvent
    public static void init(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {
            MenuScreens.m_96206_(Hostile.Containers.DEEP_LEARNER, DeepLearnerScreen::new);
            MenuScreens.m_96206_(Hostile.Containers.SIM_CHAMBER, SimChamberScreen::new);
            MenuScreens.m_96206_(Hostile.Containers.LOOT_FABRICATOR, LootFabScreen::new);
        });
        MinecraftForge.EVENT_BUS.addListener(HostileClient::tick);
    }

    @SubscribeEvent
    public static void mrl(ModelRegistryEvent e) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("hostilenetworks", "item/data_model_base"));
    }

    @SubscribeEvent
    public static void colors(ColorHandlerEvent.Item e) {
        e.getItemColors().m_92689_((stack, tint) -> {
            DataModel model = MobPredictionItem.getStoredModel(stack);
            int color = 0xFFFFFF;
            if (model != null) {
                color = model.getNameColor();
            }
            return color;
        }, new ItemLike[]{Hostile.Items.PREDICTION});
    }

    public static void tick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ++clientTicks;
        }
    }
}

