/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.Registrable;
import ovh.corail.tombstone.tileentity.BlockEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks {
    public static final EnumMap<GraveModel, Block> PLAYER_GRAVES = new EnumMap(GraveModel.class);
    public static final EnumMap<GraveModel, Block> DECORATIVE_GRAVES = new EnumMap(GraveModel.class);
    public static BlockEntityType<BlockEntityPlayerGrave> tile_grave = (BlockEntityType)Helper.unsafeNullCast();
    public static BlockEntityType<BlockEntityDecorativeGrave> tile_decorative_grave = (BlockEntityType)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:dark_marble")
    public static final Block dark_marble = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:white_marble")
    public static final Block white_marble = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:dark_marble_slab")
    public static final Block dark_marble_slab = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:white_marble_slab")
    public static final Block white_marble_slab = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:dark_marble_stairs")
    public static final Block dark_marble_stairs = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:white_marble_stairs")
    public static final Block white_marble_stairs = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:dark_marble_wall")
    public static final Block dark_marble_wall = (Block)Helper.unsafeNullCast();
    @ObjectHolder(value="tombstone:white_marble_wall")
    public static final Block white_marble_wall = (Block)Helper.unsafeNullCast();

    public static boolean isPlayerGrave(Block block) {
        return PLAYER_GRAVES.containsValue(block);
    }

    public static boolean isDecorativeGrave(Block block) {
        return DECORATIVE_GRAVES.containsValue(block);
    }

    public static boolean isAnyGrave(Block block) {
        return ModBlocks.isPlayerGrave(block) || ModBlocks.isDecorativeGrave(block);
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        Arrays.stream(GraveModel.values()).forEach(model -> {
            BlockGrave playerGrave = new BlockGrave((GraveModel)((Object)model));
            PLAYER_GRAVES.put((GraveModel)((Object)model), (Block)playerGrave);
            Registrable.register(event.getRegistry(), playerGrave, model.m_7912_());
            BlockDecorativeGrave decorativeGrave = new BlockDecorativeGrave((GraveModel)((Object)model));
            DECORATIVE_GRAVES.put((GraveModel)((Object)model), (Block)decorativeGrave);
            Registrable.register(event.getRegistry(), decorativeGrave, "decorative_" + model.m_7912_());
        });
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.DARK), "dark_marble");
        Registrable.register(event.getRegistry(), new BlockGraveMarble(BlockGraveMarble.MarbleType.WHITE), "white_marble");
        Registrable.register(event.getRegistry(), new SlabBlock(BlockGraveMarble.getBuilder()), "dark_marble_slab");
        Registrable.register(event.getRegistry(), new SlabBlock(BlockGraveMarble.getBuilder()), "white_marble_slab");
        Registrable.register(event.getRegistry(), new StairBlock(() -> dark_marble.m_49966_(), BlockGraveMarble.getBuilder()), "dark_marble_stairs");
        Registrable.register(event.getRegistry(), new StairBlock(() -> white_marble.m_49966_(), BlockGraveMarble.getBuilder()), "white_marble_stairs");
        Registrable.register(event.getRegistry(), new WallBlock(BlockGraveMarble.getBuilder()), "dark_marble_wall");
        Registrable.register(event.getRegistry(), new WallBlock(BlockGraveMarble.getBuilder()), "white_marble_wall");
        tile_grave = BlockEntityType.Builder.m_155273_(BlockEntityPlayerGrave::new, (Block[])PLAYER_GRAVES.values().toArray(new Block[0])).m_58966_(null);
        tile_decorative_grave = BlockEntityType.Builder.m_155273_(BlockEntityDecorativeGrave::new, (Block[])DECORATIVE_GRAVES.values().toArray(new Block[0])).m_58966_(null);
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        DECORATIVE_GRAVES.values().forEach(g -> Registrable.register(event.getRegistry(), new ItemBlockGrave((Block)g), Objects.requireNonNull(g.getRegistryName())));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_slab, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_slab.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_slab, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_slab.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_stairs, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_stairs.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_stairs, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_stairs.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(dark_marble_wall, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(dark_marble_wall.getRegistryName()));
        Registrable.register(event.getRegistry(), new BlockItem(white_marble_wall, new Item.Properties().m_41491_(ModTabs.mainTab)), Objects.requireNonNull(white_marble_wall.getRegistryName()));
    }

    @SubscribeEvent
    public static void registerBlockEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
        Registrable.register(event.getRegistry(), tile_decorative_grave, "tile_decorative_grave");
        Registrable.register(event.getRegistry(), tile_grave, "tile_grave");
    }
}

