/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.helper.Helper;

public record SyncServantMessage(int entityId, UUID uuid) {
    static SyncServantMessage fromBytes(FriendlyByteBuf buf) {
        return new SyncServantMessage(buf.m_130242_(), buf.m_130259_());
    }

    static void toBytes(SyncServantMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130077_(msg.uuid);
    }

    public static class Handler {
        static void handle(SyncServantMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg.entityId)).ifPresent(entity -> entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> cap.setOwnerId(msg.uuid))));
            }
            ctx.setPacketHandled(true);
        }
    }
}

