/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.helper.Helper;

public record SpellCastingMessage(int entityId, int color) {
    static SpellCastingMessage fromBytes(FriendlyByteBuf buf) {
        return new SpellCastingMessage(buf.m_130242_(), buf.readInt());
    }

    static void toBytes(SpellCastingMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.writeInt(msg.color);
    }

    public static class Handler {
        static void handle(SpellCastingMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(caster -> caster.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(c -> {
                    c.setCastingColor(msg.color);
                    if (c.isCasting()) {
                        ModTombstone.PROXY.produceParticleCasting(1.0, msg.color, (LivingEntity)caster, e -> !c.isCasting());
                    }
                })));
            }
            ctx.setPacketHandled(true);
        }
    }
}

