/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public record PrayerMessage(int entityId, UUID prayerUUID, int prayType, int leftTime) {
    static PrayerMessage fromBytes(FriendlyByteBuf buf) {
        return new PrayerMessage(buf.m_130242_(), buf.m_130259_(), buf.readShort(), buf.readInt());
    }

    static void toBytes(PrayerMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130077_(msg.prayerUUID);
        buf.writeShort(msg.prayType);
        buf.writeInt(msg.leftTime);
    }

    public static class Handler {
        static void handle(PrayerMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> {
                    Level level = ModTombstone.PROXY.getClientWorld().orElse(null);
                    if (level != null) {
                        CompoundTag tag;
                        Player prayer = level.m_46003_(msg.prayerUUID);
                        LivingEntity target = Optional.ofNullable(level.m_6815_(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).orElse(null);
                        if (prayer != null && target != null && !(tag = target.getPersistentData()).m_128403_("prayer")) {
                            tag.m_128362_("prayer", msg.prayerUUID);
                            EffectHelper.addEffect(target, ModEffects.prayer, msg.leftTime, 1, new boolean[0]);
                            ModTombstone.PROXY.producePray(target, msg.prayType, e -> !target.getPersistentData().m_128403_("prayer") || !prayer.m_6117_() || !prayer.m_21205_().m_150930_((Item)ModItems.ankh_of_pray));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

