/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;

public record EffectMessage(int entityId, MobEffectInstance effectInstance) {
    static EffectMessage fromBytes(FriendlyByteBuf buf) {
        int id = buf.m_130242_();
        MobEffect effect = Optional.ofNullable((MobEffect)Registry.f_122823_.m_7942_(buf.m_130242_())).orElse(MobEffects.f_19618_);
        int duration = buf.m_130242_();
        byte amplifier = buf.readByte();
        byte flags = buf.readByte();
        return new EffectMessage(id, new MobEffectInstance(effect, duration, (int)amplifier, (flags & 1) == 1, (flags & 2) == 2, (flags & 4) == 4, null));
    }

    static void toBytes(EffectMessage msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        Optional.of(Registry.f_122823_.m_7447_((Object)msg.effectInstance.m_19544_())).filter(i -> i != -1).ifPresent(arg_0 -> ((FriendlyByteBuf)buf).m_130130_(arg_0));
        buf.m_130130_(msg.effectInstance.m_19557_());
        buf.writeByte(msg.effectInstance.m_19564_());
        buf.writeByte((int)((byte)((msg.effectInstance.m_19571_() ? 1 : 0) + (msg.effectInstance.m_19572_() ? 2 : 0) + (msg.effectInstance.m_19575_() ? 4 : 0))));
    }

    public static class Handler {
        static void handle(EffectMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(() -> ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
                    MobEffectInstance effectInstance;
                    effectInstance.m_19562_((effectInstance = new MobEffectInstance(msg.effectInstance)).m_19557_() >= Short.MAX_VALUE);
                    entity.m_147215_(effectInstance, null);
                }));
            }
            ctx.setPacketHandled(true);
        }
    }
}

