/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.function.BooleanSupplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModPerks;

public abstract class ItemTablet
extends ItemGraveMagic {
    public ItemTablet(String name, BooleanSupplier supplierBoolean) {
        super(name, supplierBoolean);
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab) && this.isEnabled()) {
            items.add((Object)new ItemStack((ItemLike)this));
            items.add((Object)this.createAncient());
        }
    }

    @Override
    public int getUseMax() {
        return (Integer)SharedConfigTombstone.magic_item.tabletMaxUse.get();
    }

    @Override
    public int getCastingCooldown() {
        return TimeHelper.tickFromSecond((Integer)SharedConfigTombstone.magic_item.tabletCooldown.get());
    }

    @Override
    public boolean canConsumeOnUse() {
        return true;
    }

    @Override
    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        if (Helper.RANDOM.nextInt(10) + 1 <= EntityHelper.getPerkLevelWithBonus(player, ModPerks.rune_inscriber)) {
            return stack;
        }
        return super.onConsumeItem(player, stack);
    }

    public ItemStack createAncient() {
        return NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "ancient", true);
    }
}

