/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.function.BooleanSupplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemGraveMagic;

public abstract class ItemScroll
extends ItemGraveMagic {
    protected ItemScroll(String name, BooleanSupplier supplierBoolean) {
        super(name, supplierBoolean);
    }

    protected ItemScroll(String name, Item.Properties builder, BooleanSupplier supplierEnabled) {
        super(name, builder, supplierEnabled);
    }

    @Override
    public int getUseMax() {
        return 1;
    }

    @Override
    public int getCastingCooldown() {
        return 0;
    }

    @Override
    public boolean canConsumeOnUse() {
        return true;
    }

    @Override
    public CastingType getCastingType(ItemStack stack) {
        return this.isAncient(stack) ? CastingType.AREA_SCROLL : CastingType.SCROLL;
    }

    @Override
    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (EntityHelper.isValidPlayer(player) && stack.m_150930_((Item)this) && !this.isAncient(stack) && EntityHelper.noGlobalItemCooldown(player, this) && this.isTargetForCasting(player, target)) {
            if (this.canAffectTarget(stack, target)) {
                InteractionResult result = this.m_7203_(player.m_183503_(), player, hand).m_19089_();
                if (result == InteractionResult.PASS) {
                    return InteractionResult.PASS;
                }
                if (result != InteractionResult.FAIL) {
                    TARGET.put(player.m_142081_(), target);
                    return InteractionResult.SUCCESS;
                }
            }
            if (!player.f_19853_.m_5776_()) {
                LangKey.MESSAGE_CANT_APPLY_EFFECT.sendMessage(player, target.m_7755_());
            }
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            return InteractionResult.FAIL;
        }
        return super.m_6880_(stack, player, target, hand);
    }

    protected abstract boolean canAffectTarget(ItemStack var1, LivingEntity var2);

    protected boolean isTargetForCasting(Player player, LivingEntity target) {
        return player.m_7307_((Entity)target) || TameableType.isTamedBy((LivingEntity)player, (Entity)target);
    }
}

