/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemEnchantedBundle
extends BundleItem
implements ISoulConsumer,
IDisableable {
    protected final String name;
    private static final String INVENTORY_NBT_LIST = "Items";

    public ItemEnchantedBundle() {
        super(new Item.Properties().m_41491_(ModTabs.mainTab).m_41487_(1).m_41486_());
        this.name = "enchanted_bundle";
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab) && this.isEnabled()) {
            items.add((Object)new ItemStack((ItemLike)Items.f_151058_));
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public String getSimpleName() {
        return this.name;
    }

    public String m_5524_() {
        return "tombstone.item." + this.name;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add(ModEnchantments.soulbound.m_44700_(1));
        if (!this.isEnabled()) {
            tooltip.add((Component)LangKey.MESSAGE_DISABLED.getText(StyleType.COLOR_OFF, new Object[0]));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Optional<ListTag> optionalList = NBTStackHelper.getListOrEmpty(stack, INVENTORY_NBT_LIST);
        if (optionalList.isPresent()) {
            if (EntityHelper.isValidServerPlayer(player)) {
                optionalList.get().forEach(nbt -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt)), (int)-1));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_151058_));
                NBTStackHelper.removeKeyName(stack, INVENTORY_NBT_LIST);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.enchanted_bundle);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_(Items.f_151058_)) {
            ItemStack enchantedBundle = new ItemStack((ItemLike)this);
            NBTStackHelper.getListOrEmpty(stack, INVENTORY_NBT_LIST).ifPresent(list -> enchantedBundle.m_41784_().m_128365_(INVENTORY_NBT_LIST, (Tag)list));
            player.m_21008_(InteractionHand.MAIN_HAND, enchantedBundle);
            ModTriggers.ENCHANTED_BUNDLE.trigger(player);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.allowed_magic_items.allowEnchantedBundle.get();
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

