/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModSounds;

public interface IChanneling {
    public static final Map<UUID, Long> USING = new ConcurrentHashMap<UUID, Long>();
    public static final Map<UUID, LivingEntity> TARGET = new ConcurrentHashMap<UUID, LivingEntity>();

    default public Item asItem() {
        return (Item)this;
    }

    public CastingType getCastingType(ItemStack var1);

    default public void onChanneling(ItemStack stack, LivingEntity entity, int timeLeft) {
        boolean isStarting;
        if (!stack.m_150930_(this.asItem()) || !EntityHelper.isValidPlayer((Entity)entity)) {
            return;
        }
        Player player = (Player)entity;
        boolean bl = isStarting = timeLeft == this.asItem().m_8105_(stack);
        if (isStarting) {
            if (player.f_19853_.m_5776_()) {
                ModTombstone.PROXY.produceParticleCasting(this.getCastingType(stack), Optional.ofNullable(TARGET.get(player.m_142081_())).orElse((LivingEntity)player), p -> !player.m_6117_() || player.m_21252_() == 1);
            } else {
                int concentrationLevel = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus(player, ModPerks.concentration)).orElse(0);
                USING.put(player.m_142081_(), TimeHelper.systemTime() + (long)((float)TimeUnit.SECONDS.toMillis(1L) * ((float)this.asItem().m_8105_(stack) / 20.0f * (concentrationLevel == 1 ? 0.8f : (concentrationLevel > 1 ? 0.5f : 1.0f)))));
                ModSounds.playSoundAllAround(SoundEvents.f_11862_, SoundSource.PLAYERS, player.m_183503_(), player.m_142538_(), 0.5f, 0.5f);
            }
        } else if (!player.f_19853_.m_5776_() && USING.containsKey(player.m_142081_()) && USING.get(player.m_142081_()) < TimeHelper.systemTime() && player.m_6117_() && player.m_21211_().m_150930_(this.asItem())) {
            ItemStack resultStack = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)player.m_21211_().m_41777_(), (int)0, (ItemStack)player.m_21211_().m_41671_(player.f_19853_, (LivingEntity)player));
            if (resultStack != player.m_21211_()) {
                player.m_21008_(player.m_7655_(), resultStack);
            }
            player.m_5810_();
        }
    }

    default public void resetCasting(ServerPlayer player) {
        UUID uuid = player.m_142081_();
        USING.remove(uuid);
        TARGET.remove(uuid);
    }
}

