/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.CharMatcher;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.StyleType;

public class FontHelper {
    private static final CharMatcher ALLOWED_CHAR = CharMatcher.anyOf((CharSequence)"abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.:,;'\"(!?)+-*/_\u00c3\u00a9\u00c3\u00a8\u00c3\u00a0\u00c3\u00a7\u00c3\u00b9\u00c3\u00aa\u00c3\u00bb\u00c3\u00a2");

    public static void drawCentered(PoseStack poseStack, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCentered(poseStack, font, text.m_7532_(), x, y, color);
    }

    public static void drawCentered(PoseStack poseStack, Font font, FormattedCharSequence text, float x, float y, int color) {
        font.m_92877_(poseStack, text, x - (float)font.m_92724_(text) / 2.0f, y, color);
    }

    public static void drawCenteredFantasy(PoseStack poseStack, Font font, Component text, float x, float y, int color) {
        FontHelper.drawCentered(poseStack, font, FontHelper.withFantasyFont(text), x, y, color);
    }

    public static void drawFantasy(PoseStack poseStack, Font font, Component text, float x, float y, int color) {
        font.m_92889_(poseStack, FontHelper.withFantasyFont(text), x, y, color);
    }

    public static Component withFantasyFont(Component component) {
        if (((ConfigTombstone.Client.FontRule)((Object)ConfigTombstone.client.fontRule.get())).isVanilla()) {
            return component;
        }
        String langCode = Minecraft.m_91087_().f_91066_.f_92075_;
        if (langCode.startsWith("en") || langCode.startsWith("fr") || langCode.startsWith("nl")) {
            return component.m_6881_().m_130948_(StyleType.FANTASY);
        }
        return component;
    }

    public static boolean canBeFantasy(String text) {
        return ALLOWED_CHAR.matchesAllOf((CharSequence)text);
    }
}

