/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import ovh.corail.tombstone.helper.EntityHelper;

public class ServantFollowOwnerGoal
extends Goal {
    private final Mob servant;
    private Player owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public ServantFollowOwnerGoal(Mob servant, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.servant = servant;
        this.level = servant.f_19853_;
        this.speedModifier = speedModifier;
        this.navigation = servant.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_8036_() {
        if (this.servant.m_21523_()) {
            return false;
        }
        EntityHelper.getServantOwner((Entity)this.servant).ifPresent(owner -> {
            this.owner = owner;
        });
        if (this.owner == null) return false;
        if (!this.owner.f_19853_.m_46472_().equals((Object)this.servant.f_19853_.m_46472_())) return false;
        if (this.owner.m_5833_()) return false;
        double d = this.servant.m_20280_((Entity)this.owner);
        double d2 = this.startDistance * this.startDistance;
        double d3 = this.servant.m_5448_() != null && this.servant.m_5448_().m_6084_() ? 4.0 : 1.0;
        if (!(d >= d2 * d3)) return false;
        return true;
    }

    public boolean m_8045_() {
        return !this.servant.m_21523_() && !this.navigation.m_26571_() && this.servant.m_20280_((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.servant.m_21439_(BlockPathTypes.WATER);
        this.servant.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.servant.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.servant.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.servant.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.servant.m_21523_() && !this.servant.m_20159_()) {
                if (this.servant.m_20280_((Entity)this.owner) >= 144.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            if (!this.maybeTeleportTo(blockpos.m_123341_() + this.randomIntInclusive(-3, 3), blockpos.m_123342_() + this.randomIntInclusive(-1, 1), blockpos.m_123343_() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.servant.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.servant.m_146908_(), this.servant.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(pos.m_7495_());
        if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_141950_((Vec3i)this.servant.m_142538_());
        return this.level.m_45756_((Entity)this.servant, this.servant.m_142469_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.servant.m_21187_().nextInt(max - min + 1) + min;
    }
}

