/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public final class CommandTBTeleport
extends TombstoneCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(s -> new TranslatableComponent("commands.locate.invalid", new Object[]{s}));

    @Override
    public String getName() {
        return TombstoneCommand.Name.TELEPORT.get();
    }

    @Override
    protected Predicate<CommandSourceStack> getInitialRequirement() {
        return p -> true;
    }

    @Override
    protected Component getUsage() {
        return new TranslatableComponent("tombstone.command." + this.getName() + ".default.usage");
    }

    private int showUsage(CommandSourceStack source, SubCommand subCmd) {
        source.m_81354_((Component)new TranslatableComponent("tombstone.command." + this.getName() + "." + subCmd.name().toLowerCase(Locale.US) + ".usage"), false);
        return 1;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.executes(this::showUsage);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.POS.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.POS))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)EntityArgument.m_91449_()).executes(this::showUsage)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> {
            Entity source = EntityArgument.m_91452_((CommandContext)c, (String)"source");
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)c, (String)"pos");
            return this.teleport((CommandSourceStack)c.getSource(), source, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (ServerLevel)source.f_19853_);
        })).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> {
            BlockPos pos = BlockPosArgument.m_174395_((CommandContext)c, (String)"pos");
            return this.teleport((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"source"), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), DimensionArgument.m_88808_((CommandContext)c, (String)"dim"));
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.PLAYER.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.PLAYER))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)EntityArgument.m_91449_()).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.PLAYER))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(c -> {
            Entity target = EntityArgument.m_91452_((CommandContext)c, (String)"target");
            BlockPos targetPos = target.m_142538_();
            return this.teleport((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"source"), targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_(), (ServerLevel)target.f_19853_);
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.GRAVE.literal().requires(this.defaultPermission)).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), ((CommandSourceStack)c.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)c, (String)"player")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(c -> this.teleportGrave((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), EntityArgument.m_91474_((CommandContext)c, (String)"target"))))))).then(SubCommand.DEATH.literal().executes(c -> this.teleportDeath((CommandSourceStack)c.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.HOME.literal().requires(this.defaultPermission)).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), ((CommandSourceStack)c.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)c, (String)"player")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(c -> this.teleportHome((CommandSourceStack)c.getSource(), EntityArgument.m_91474_((CommandContext)c, (String)"player"), EntityArgument.m_91474_((CommandContext)c, (String)"target"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.DISCOVERY.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.DISCOVERY))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"target"), ResourceOrTagLocationArgument.m_210970_((CommandContext)c, (String)"minecraft:village")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122882_)).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"target"), ResourceOrTagLocationArgument.m_210970_((CommandContext)c, (String)"structure")))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> this.teleportDiscovery((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"target"), ResourceOrTagLocationArgument.m_210970_((CommandContext)c, (String)"structure"), DimensionArgument.m_88808_((CommandContext)c, (String)"dim")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)SubCommand.BIOME.literal().requires(this.defaultPermission)).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(c -> this.showUsage((CommandSourceStack)c.getSource(), SubCommand.BIOME))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"biome", (ArgumentType)ResourceOrTagLocationArgument.m_210968_((ResourceKey)Registry.f_122885_)).executes(c -> this.teleportBiome((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"target"), (ResourceOrTagLocationArgument.Result<Biome>)ResourceOrTagLocationArgument.m_210952_((CommandContext)c, (String)"biome")))).then(Commands.m_82129_((String)"dim", (ArgumentType)DimensionArgument.m_88805_()).executes(c -> this.teleportBiome((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"target"), (ResourceOrTagLocationArgument.Result<Biome>)ResourceOrTagLocationArgument.m_210952_((CommandContext)c, (String)"biome"), DimensionArgument.m_88808_((CommandContext)c, (String)"dim")))))));
        return builder;
    }

    private void onTeleport(CommandSourceStack sender, Entity source, Location destination, ServerLevel targetWorld) {
        Entity newEntity = Helper.teleport(source, destination, targetWorld);
        if (EntityHelper.isValidPlayer(newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newEntity, StyleType.MESSAGE_SPELL, new Object[0]);
        }
        this.sendMessage(sender, LangKey.MESSAGE_TELEPORT_TARGET_TO_LOCATION.getText(newEntity.m_7755_(), destination.x, destination.y, destination.z, destination.getDimString()), false);
    }

    private int teleport(CommandSourceStack sender, Entity source, int x, int y, int z, ServerLevel targetWorld) {
        CommandTBTeleport.checkAlive(source);
        CommandTBTeleport.checkNotSpectator(source);
        Location sourceLoc = new Location(source);
        Location destLoc = new Location(x, y, z, (Level)targetWorld);
        if (sourceLoc.equals(destLoc)) {
            throw LangKey.MESSAGE_SAME_LOCATION.asCommandException(new Object[0]);
        }
        CommandTBTeleport.checkValidPos((Level)targetWorld, destLoc.getPos());
        destLoc = new SpawnHelper(targetWorld, Helper.getCloserValidPos((Level)targetWorld, destLoc.getPos())).findSpawnPlace();
        if (destLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, source, destLoc, targetWorld);
        return 1;
    }

    private int teleportGrave(CommandSourceStack sender, ServerPlayer player, ServerPlayer target) {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Player)player);
        MinecraftServer server = sender.m_81377_();
        Location lastGrave = DeathHandler.INSTANCE.getLastGrave(server, target);
        if (lastGrave.isOrigin() && (lastGrave = ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((Player)target, ModItems.grave_key))).isOrigin()) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        ServerLevel targetWorld = this.getOrThrowWorld(server, lastGrave.dim);
        CommandTBTeleport.checkValidPos((Level)targetWorld, lastGrave.getPos());
        this.onTeleport(sender, (Entity)player, lastGrave, targetWorld);
        return 1;
    }

    private int teleportDeath(CommandSourceStack sender) throws CommandSyntaxException {
        if ((Integer)ConfigTombstone.general.cooldownTeleportDeath.get() < 0) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        ServerPlayer player = sender.m_81375_();
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Player)player);
        Location lastDeathLocation = DeathHandler.INSTANCE.getLastDeathLocation((Player)player);
        if (lastDeathLocation.isOrigin()) {
            throw LangKey.MESSAGE_NO_DEATH_LOCATION.asCommandException(new Object[0]);
        }
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownType.TELEPORT_DEATH);
        if (cd > 0) {
            LangKey.MESSAGE_COMMAND_IN_COOLDOWN.sendMessage((Player)player, TimeHelper.getTimeStringWithUnit(cd));
            return 0;
        }
        ServerLevel world = this.getOrThrowWorld(sender.m_81377_(), lastDeathLocation.dim);
        Location location = new SpawnHelper(world, lastDeathLocation.getPos()).findSpawnPlace();
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.TELEPORT_DEATH);
        this.onTeleport(sender, (Entity)player, location, world);
        return 1;
    }

    private int teleportHome(CommandSourceStack sender, ServerPlayer player, ServerPlayer target) {
        CommandTBTeleport.checkAlive((Entity)player);
        CommandTBTeleport.checkNotSpectator((Player)player);
        Pair<ServerLevel, BlockPos> spawnPoint = CommandTBTeleport.getRespawnPoint(sender.m_81377_(), target);
        Location location = new SpawnHelper((ServerLevel)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight()).findSpawnPlace();
        CommandTBTeleport.checkValidPos((Level)spawnPoint.getLeft(), location.getPos());
        this.onTeleport(sender, (Entity)player, location, (ServerLevel)spawnPoint.getLeft());
        return 1;
    }

    public static Pair<ServerLevel, BlockPos> getRespawnPoint(MinecraftServer server, ServerPlayer player) {
        ServerLevel world;
        BlockPos spawnPos = player.m_8961_();
        if (spawnPos != null && (world = server.m_129880_(player.m_8963_())) != null) {
            return Pair.of((Object)world, (Object)spawnPos);
        }
        ServerLevel overworld = server.m_129783_();
        return Pair.of((Object)overworld, (Object)overworld.m_8900_());
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, ResourceOrTagLocationArgument.Result<ConfiguredStructureFeature<?, ?>> structureResult) throws CommandSyntaxException {
        return this.teleportDiscovery(sender, target, structureResult, (ServerLevel)target.f_19853_);
    }

    private int teleportDiscovery(CommandSourceStack sender, Entity target, ResourceOrTagLocationArgument.Result<ConfiguredStructureFeature<?, ?>> structureResult, ServerLevel world) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        Registry registry = sender.m_81372_().m_5962_().m_175515_(Registry.f_122882_);
        HolderSet holderset = (HolderSet)((Optional)structureResult.m_207418_().map(k -> registry.m_203636_(k).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})), arg_0 -> ((Registry)registry).m_203431_(arg_0))).orElseThrow(() -> ERROR_INVALID.create((Object)structureResult.m_207276_()));
        Pair<Location, ResourceLocation> res = Helper.findNearestStructure(world, target.m_142538_().m_142022_(Helper.RANDOM.nextGaussian() * 2000.0, 0.0, Helper.RANDOM.nextGaussian() * 2000.0), holderset, true);
        if (((Location)res.getLeft()).isOrigin()) {
            throw LangKey.MESSAGE_NO_STRUCTURE.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, ((Location)res.getLeft()).getPos()).findStructurePlace((ResourceLocation)res.getRight());
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private int teleportBiome(CommandSourceStack sender, Entity target, ResourceOrTagLocationArgument.Result<Biome> biomeResult) throws CommandSyntaxException {
        return this.teleportBiome(sender, target, biomeResult, (ServerLevel)target.f_19853_);
    }

    private int teleportBiome(CommandSourceStack sender, Entity target, ResourceOrTagLocationArgument.Result<Biome> biomeResult, ServerLevel world) throws CommandSyntaxException {
        CommandTBTeleport.checkAlive(target);
        CommandTBTeleport.checkNotSpectator(target);
        Location location = Helper.findNearestBiome(world, target.m_142538_(), biomeResult);
        if (location.isOrigin()) {
            throw LangKey.MESSAGE_NO_BIOME.asCommandException(new Object[0]);
        }
        Location spawnLoc = new SpawnHelper(world, location.getPos()).findSpawnPlace();
        if (spawnLoc.isOrigin()) {
            throw LangKey.MESSAGE_NO_SPAWN.asCommandException(new Object[0]);
        }
        this.onTeleport(sender, target, spawnLoc, world);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        POS,
        PLAYER,
        GRAVE,
        DEATH,
        HOME,
        DISCOVERY,
        BIOME;

    }
}

