/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public final class CommandTBRestoreInventory
extends TombstoneCommand {
    @Override
    public String getName() {
        return TombstoneCommand.Name.RESTORE_INVENTORY.get();
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::restoreInventory)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(this::restoreInventory));
    }

    private int restoreInventory(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = CommandTBRestoreInventory.getPlayerOrCommandSender(ctx, "player");
        CommandTBRestoreInventory.checkAlive((Entity)target);
        CommandTBRestoreInventory.checkNotSpectator((Player)target);
        boolean success = false;
        List<Location> graveLocations = DeathHandler.INSTANCE.getGraveList(target);
        for (Location lastGrave : graveLocations) {
            if (!this.restoreGrave(((CommandSourceStack)ctx.getSource()).m_81377_(), target, lastGrave)) continue;
            success = true;
        }
        if (this.restoreGrave(((CommandSourceStack)ctx.getSource()).m_81377_(), target, ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((Player)target, ModItems.grave_key)))) {
            success = true;
        }
        if (!success) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        LangKey.MESSAGE_RECOVER_LOST_ITEMS.sendMessage((Player)target, StyleType.MESSAGE_SPELL, new Object[0]);
        return 1;
    }

    private boolean restoreGrave(MinecraftServer server, ServerPlayer player, Location loc) {
        ServerLevel currentWorld;
        if (!loc.isOrigin() && (currentWorld = server.m_129880_(loc.dim)) != null) {
            BlockEntityPlayerGrave grave = Helper.getPlayerGrave((Level)currentWorld, loc.getPos()).orElse(null);
            if (grave != null) {
                ModItems.grave_key.removeKeyForGraveInInventory((Player)player, grave);
                grave.giveInventory(player);
                return true;
            }
            DeathHandler.INSTANCE.removeGrave(player, loc);
        }
        return false;
    }
}

