/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.entity.ai.ServantFollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.ServantOwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.ServantOwnerHurtTargetGoal;
import ovh.corail.tombstone.entity.ai.spell.BuffOtherSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.CurseSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FangsSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.FireBallSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.HealSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.ScorchSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SelfBuffSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellCastingGoal;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;
import ovh.corail.tombstone.entity.ai.spell.ThunderSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WitherSkullSpellGoal;
import ovh.corail.tombstone.entity.ai.spell.WololoSpellGoal;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncServantMessage;
import ovh.corail.tombstone.registry.ModEffects;

public class ServantEntityImpl
implements IServantEntity {
    @Nullable
    protected UUID ownerId = null;
    protected CasterType casterType = CasterType.getDefault();
    private static final String CASTER_TYPE = "caster_type";
    private static final String SERVANT_OWNER_ID = "servant_owner_id";

    @Override
    public Optional<UUID> getOwnerId() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public boolean isSpellCaster() {
        return this.getCasterType() != CasterType.NONE.ordinal();
    }

    @Override
    public int getCasterType() {
        return this.casterType.ordinal();
    }

    @Override
    public void setSpellCaster(int casterType) {
        this.casterType = CasterType.byId(casterType);
    }

    @Override
    public void setAI(PathfinderMob servant) {
        servant.m_21530_();
        servant.m_21553_(true);
        EntityHelper.resetAttackAction((LivingEntity)servant);
        servant.f_21345_.m_148105_().removeIf(g -> !(g.m_26015_() instanceof MeleeAttackGoal) && !(g.m_26015_() instanceof RangedAttackGoal) && !(g.m_26015_() instanceof RangedBowAttackGoal) && !(g.m_26015_() instanceof RangedCrossbowAttackGoal) && !(g.m_26015_() instanceof SpellCastingGoal) && !(g.m_26015_() instanceof SpellUseGoal));
        servant.f_21346_.m_148096_();
        servant.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)servant));
        servant.f_21345_.m_25352_(3, (Goal)new ServantFollowOwnerGoal((Mob)servant, 1.0, 5.0f, 2.5f, false));
        servant.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal(servant, 1.0));
        servant.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)servant, Player.class, 8.0f));
        servant.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)servant));
        servant.f_21346_.m_25352_(1, (Goal)new ServantOwnerHurtByTargetGoal((Mob)servant));
        servant.f_21346_.m_25352_(2, (Goal)new ServantOwnerHurtTargetGoal((Mob)servant));
        servant.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal(servant, new Class[0]));
        if (this.isSpellCaster() && servant.f_21345_.m_148105_().stream().noneMatch(g -> g.m_26015_() instanceof SpellCastingGoal)) {
            servant.f_21345_.m_25352_(1, (Goal)new SpellCastingGoal(servant));
            switch (this.casterType) {
                case DARKNESS: {
                    servant.f_21345_.m_25352_(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.f_21345_.m_25352_(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.unstable_intangibility, 2400)));
                    servant.f_21345_.m_25352_(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.f_19615_, 200)));
                    servant.f_21345_.m_25352_(5, (Goal)new WitherSkullSpellGoal(servant));
                    servant.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLACK));
                    break;
                }
                case LIGHTNING: {
                    servant.f_21345_.m_25352_(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.f_21345_.m_25352_(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.lightning_resistance, 2400)));
                    servant.f_21345_.m_25352_(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.f_19620_, 200)));
                    servant.f_21345_.m_25352_(5, (Goal)new ThunderSpellGoal(servant));
                    servant.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal(servant, DyeColor.BLUE));
                    break;
                }
                case FIRE: {
                    servant.f_21345_.m_25352_(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(MobEffects.f_19607_, 2400, 3)));
                    servant.f_21345_.m_25352_(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(MobEffects.f_19607_, 2400, 3)));
                    servant.f_21345_.m_25352_(4, (Goal)new ScorchSpellGoal(servant));
                    servant.f_21345_.m_25352_(5, (Goal)new FireBallSpellGoal(servant));
                    servant.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal(servant, DyeColor.ORANGE));
                    break;
                }
                case FROST: {
                    servant.f_21345_.m_25352_(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.f_21345_.m_25352_(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(ModEffects.frost_resistance, 2400)));
                    servant.f_21345_.m_25352_(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.f_19597_, 200)));
                    servant.f_21345_.m_25352_(5, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(ModEffects.frostbite, 200, 2)));
                    servant.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal(servant, DyeColor.WHITE));
                    break;
                }
                case EARTH: {
                    servant.f_21345_.m_25352_(2, (Goal)new SelfBuffSpellGoal(servant, new MobEffectInstance(MobEffects.f_19606_, 2400, 2)));
                    servant.f_21345_.m_25352_(3, (Goal)new BuffOtherSpellGoal(servant, new MobEffectInstance(MobEffects.f_19606_, 2400, 2)));
                    servant.f_21345_.m_25352_(4, (Goal)new CurseSpellGoal(servant, new MobEffectInstance(MobEffects.f_19613_, 200)));
                    servant.f_21345_.m_25352_(5, (Goal)new FangsSpellGoal(servant));
                    servant.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal(servant, DyeColor.GREEN));
                }
            }
            servant.f_21345_.m_25352_(6, (Goal)new HealSpellGoal(servant));
            this.getOwnerId().ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new SyncServantMessage(servant.m_142049_(), (UUID)ownerId), (LivingEntity)servant));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.ownerId != null) {
            nbt.m_128362_(SERVANT_OWNER_ID, this.ownerId);
        }
        nbt.m_128376_(CASTER_TYPE, (short)this.casterType.ordinal());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128403_(SERVANT_OWNER_ID)) {
            this.ownerId = nbt.m_128342_(SERVANT_OWNER_ID);
        }
        if (nbt.m_128425_(CASTER_TYPE, 2)) {
            this.casterType = CasterType.byId(nbt.m_128448_(CASTER_TYPE));
        }
    }

    public static enum CasterType {
        NONE,
        LIGHTNING,
        DARKNESS,
        FIRE,
        FROST,
        EARTH;


        public static CasterType getDefault() {
            return NONE;
        }

        public static CasterType byId(int id) {
            return id >= 0 && id < CasterType.values().length ? CasterType.values()[id] : CasterType.getDefault();
        }

        public static int getRandomId() {
            return Helper.RANDOM.nextInt(CasterType.values().length - 1) + 1;
        }

        public static CasterType getRandom() {
            return CasterType.byId(CasterType.getRandomId());
        }
    }
}

