/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import ovh.corail.tombstone.api.capability.IProtectedEntity;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncProtectionMessage;

public class ProtectedEntityImpl
implements IProtectedEntity {
    protected boolean active = false;
    private final Function<LivingEntity, GlobalPos> defaultSafeLocation = entity -> GlobalPos.m_122643_((ResourceKey)entity.f_19853_.m_46472_(), (BlockPos)entity.m_142538_().m_142082_(Helper.RANDOM.nextInt(101) - 50, 0, Helper.RANDOM.nextInt(101) - 50));
    protected final Function<LivingEntity, Optional<GlobalPos>> safeLocation;
    private static final String ACTIVE = "active";

    public ProtectedEntityImpl() {
        this.safeLocation = entity -> Optional.empty();
    }

    public ProtectedEntityImpl(Function<LivingEntity, Optional<GlobalPos>> safeLocation) {
        this.safeLocation = safeLocation;
    }

    @Override
    public void apply(LivingEntity entity, boolean active) {
        this.active = active;
        if (!entity.f_19853_.m_5776_()) {
            PacketHandler.sendToAllTrackingPlayers(new SyncProtectionMessage(entity.m_142049_(), active), entity);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public GlobalPos getSafeLocation(LivingEntity entity) {
        return this.safeLocation.apply(entity).orElse(this.defaultSafeLocation.apply(entity));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_(ACTIVE, this.active);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_(ACTIVE, 1)) {
            this.active = nbt.m_128471_(ACTIVE);
        }
    }
}

