/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Perk
extends ForgeRegistryEntry<Perk>
implements Comparable<Perk>,
StringRepresentable {
    protected final String name;
    protected final ResourceLocation icon;
    protected Component translation;
    protected Component description;

    public Perk(String name, ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract int getLevelMax();

    public boolean isDisabled(@Nullable Player player) {
        return false;
    }

    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    public int getLevelBonus(Player player) {
        return 0;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public final String getTranslationKey() {
        return "tombstone.perk." + this.name;
    }

    public Component getTranslation() {
        if (this.translation == null) {
            this.translation = new TranslatableComponent(this.getTranslationKey());
        }
        return this.translation;
    }

    public Component getDescription() {
        if (this.description == null) {
            this.description = new TranslatableComponent(this.getTranslationKey() + ".desc");
        }
        return this.description;
    }

    public List<Component> getCurrentBonusInfo(int level) {
        return Collections.emptyList();
    }

    public List<Component> getNextBonusInfo(int nextLevel) {
        return this.getCurrentBonusInfo(nextLevel);
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public int compareTo(Perk perk) {
        return this.name.compareTo(perk.name);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.name.equals(((Perk)o).name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

