/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.recipes.JsonHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionProviderRecipe
implements Recipe<RecipeWrapper> {
    public static final RecipeType<PotionProviderRecipe> TYPE = RecipeType.m_44119_((String)"jeed:potion_provider");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final NonNullList<ItemStack> providers;
    private final List<Potion> potions;

    public PotionProviderRecipe(ResourceLocation id, NonNullList<ItemStack> providers, List<Potion> potions) {
        this.id = id;
        this.providers = providers;
        this.potions = potions;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return "potion_provider";
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)Ingredient.f_43901_);
        return nonNullList;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper wrapper) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public NonNullList<ItemStack> getProviders() {
        return this.providers;
    }

    public List<Potion> getPotions() {
        return this.potions;
    }

    private static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PotionProviderRecipe> {
        public Serializer() {
            this.setRegistryName(Jeed.res("potion_provider"));
        }

        public PotionProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            List<Potion> potions;
            NonNullList<ItemStack> providers = JsonHelper.readItemStackList(GsonHelper.m_13933_((JsonObject)json, (String)"providers"));
            try {
                potions = JsonHelper.readPotionList(GsonHelper.m_13933_((JsonObject)json, (String)"potions"));
            }
            catch (Exception ignored) {
                potions = new ArrayList<Potion>();
            }
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            return new PotionProviderRecipe(recipeId, providers, potions);
        }

        @Nullable
        public PotionProviderRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList providers = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
            for (int j = 0; j < providers.size(); ++j) {
                providers.set(j, (Object)buffer.m_130267_());
            }
            int x = buffer.m_130242_();
            ArrayList<Potion> potions = new ArrayList<Potion>();
            for (int y = 0; y < x; ++y) {
                potions.add(JsonHelper.getPotion(buffer.m_130281_()));
            }
            return new PotionProviderRecipe(recipeId, (NonNullList<ItemStack>)providers, potions);
        }

        public void toNetwork(FriendlyByteBuf buffer, PotionProviderRecipe recipe) {
            buffer.m_130130_(recipe.providers.size());
            for (ItemStack result : recipe.providers) {
                buffer.m_130055_(result);
            }
            buffer.m_130130_(recipe.potions.size());
            for (Potion potion : recipe.potions) {
                buffer.m_130085_(potion.getRegistryName());
            }
        }
    }
}

