/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.recipes.JsonHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class EffectProviderRecipe
implements Recipe<RecipeWrapper> {
    public static final RecipeType<EffectProviderRecipe> TYPE = RecipeType.m_44119_((String)"jeed:effect_provider");
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final MobEffect effect;
    private final boolean allEffects;
    private final NonNullList<ItemStack> providers;

    public EffectProviderRecipe(ResourceLocation id, MobEffect effect, NonNullList<ItemStack> providers) {
        this.id = id;
        this.effect = effect;
        this.providers = providers;
        this.allEffects = false;
    }

    public EffectProviderRecipe(ResourceLocation id, NonNullList<ItemStack> providers) {
        this.id = id;
        this.effect = null;
        this.providers = providers;
        this.allEffects = true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return "effect_provider";
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)Ingredient.f_43901_);
        return nonNullList;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(RecipeWrapper wrapper) {
        return null;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public Collection<MobEffect> getEffects() {
        return this.allEffects ? ForgeRegistries.MOB_EFFECTS.getValues() : Collections.singletonList(this.effect);
    }

    public NonNullList<ItemStack> getProviders() {
        return this.providers;
    }

    private static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<EffectProviderRecipe> {
        public Serializer() {
            this.setRegistryName(Jeed.res("effect_provider"));
        }

        public EffectProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<ItemStack> providers = JsonHelper.readItemStackList(GsonHelper.m_13933_((JsonObject)json, (String)"providers"));
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            String effectID = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject("effect"), (String)"id");
            if (effectID.equals("all") || effectID.equals("minecraft:all")) {
                return new EffectProviderRecipe(recipeId, providers);
            }
            MobEffect effect = JsonHelper.getEffect(new ResourceLocation(effectID));
            return new EffectProviderRecipe(recipeId, effect, providers);
        }

        @Nullable
        public EffectProviderRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList providers = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
            for (int j = 0; j < providers.size(); ++j) {
                providers.set(j, (Object)buffer.m_130267_());
            }
            ResourceLocation id = buffer.m_130281_();
            if (id.m_135815_().equals("all")) {
                return new EffectProviderRecipe(recipeId, (NonNullList<ItemStack>)providers);
            }
            MobEffect effect = JsonHelper.getEffect(id);
            return new EffectProviderRecipe(recipeId, effect, (NonNullList<ItemStack>)providers);
        }

        public void toNetwork(FriendlyByteBuf buffer, EffectProviderRecipe recipe) {
            buffer.m_130130_(recipe.providers.size());
            for (ItemStack result : recipe.providers) {
                buffer.m_130055_(result);
            }
            ResourceLocation res = recipe.allEffects ? new ResourceLocation("all") : recipe.effect.getRegistryName();
            buffer.m_130085_(res);
        }
    }
}

