/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei.ingredient;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EffectInstanceRenderer
implements IIngredientRenderer<MobEffectInstance> {
    public static final EffectInstanceRenderer INSTANCE = new EffectInstanceRenderer(true);
    public static final EffectInstanceRenderer INSTANCE_SLOT = new EffectInstanceRenderer(false);
    private final Minecraft MC = Minecraft.m_91087_();
    private final boolean offset;

    public EffectInstanceRenderer(boolean offset) {
        this.offset = offset;
    }

    public void render(PoseStack matrixStack, MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        MobEffectTextureManager effectTextures = this.MC.m_91306_();
        TextureAtlasSprite textureatlassprite = effectTextures.m_118732_(effect);
        RenderSystem.m_69478_();
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        int o = this.offset ? -1 : 0;
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)o, (int)o, (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
        RenderSystem.m_69461_();
    }

    public List<Component> getTooltip(MobEffectInstance effectInstance, TooltipFlag tooltipFlag) {
        return this.getTooltipsWithDescription(effectInstance, tooltipFlag, false);
    }

    public List<Component> getTooltipsWithDescription(MobEffectInstance effectInstance, TooltipFlag tooltipFlag, boolean reactsToShift) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (effectInstance != null) {
            boolean showDescription;
            MobEffect effect = effectInstance.m_19544_();
            Object name = I18n.m_118938_((String)effect.m_19481_(), (Object[])new Object[0]);
            int amp = effectInstance.m_19564_();
            if (amp >= 1 && amp <= 9) {
                name = (String)name + " " + I18n.m_118938_((String)("enchantment.level." + (amp + 1)), (Object[])new Object[0]);
            }
            tooltip.add((Component)new TextComponent((String)name));
            TextComponent colorValue = new TextComponent("#" + Integer.toHexString(effect.m_19484_()));
            colorValue.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)effect.m_19484_())));
            MutableComponent color = new TranslatableComponent("jeed.tooltip.color").m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)new TranslatableComponent("jeed.tooltip.color_complete", new Object[]{color, colorValue}));
            if (effect.m_19486_()) {
                tooltip.add((Component)new TranslatableComponent("jeed.tooltip.beneficial").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)new TranslatableComponent("jeed.tooltip.harmful").m_130940_(ChatFormatting.RED));
            }
            boolean bl = showDescription = reactsToShift && Screen.m_96638_();
            if (showDescription) {
                ResourceLocation res = effect.getRegistryName();
                tooltip.add((Component)new TranslatableComponent("effect." + res.m_135827_() + "." + res.m_135815_() + ".description").m_130940_(ChatFormatting.GRAY));
            } else {
                ArrayList list1 = Lists.newArrayList();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (!list1.isEmpty()) {
                    tooltip.add(TextComponent.f_131282_);
                    tooltip.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
                    for (Pair pair : list1) {
                        AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                        double d0 = attributemodifier2.m_22218_();
                        double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                        if (d0 > 0.0) {
                            tooltip.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        tooltip.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
                    }
                }
            }
            if (tooltipFlag.m_7050_()) {
                tooltip.add((Component)new TextComponent(effect.getRegistryName().toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }

    public int getWidth() {
        return this.offset ? 16 : 18;
    }

    public int getHeight() {
        return this.offset ? 16 : 18;
    }
}

