/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalRedstoneItemWrapper;
import reliquary.reference.Settings;
import reliquary.util.WorldHelper;

public class PedestalRedstoneWrapper
implements IPedestalRedstoneItemWrapper {
    private final boolean powered;

    private PedestalRedstoneWrapper(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void updateRedstone(ItemStack stack, Level level, IPedestal pedestal) {
        List<BlockPos> pedestalsInRange = pedestal.getPedestalsInRange(level, (Integer)Settings.COMMON.blocks.pedestal.redstoneWrapperRange.get());
        BlockPos thisPos = pedestal.getBlockPosition();
        boolean buttonEnabled = pedestal.switchedOn();
        for (BlockPos pos : pedestalsInRange) {
            if (pos.equals((Object)thisPos)) continue;
            WorldHelper.getBlockEntity((BlockGetter)level, pos, IPedestal.class).ifPresent(pedestalInRange -> {
                if (this.powered || buttonEnabled || level.m_46753_(pedestal.getBlockPosition())) {
                    pedestalInRange.switchOn(level, thisPos);
                } else {
                    pedestalInRange.switchOff(level, thisPos);
                }
            });
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
        List<BlockPos> pedestalsInRange = pedestal.getPedestalsInRange(level, (Integer)Settings.COMMON.blocks.pedestal.redstoneWrapperRange.get());
        BlockPos thisPos = pedestal.getBlockPosition();
        for (BlockPos pos : pedestalsInRange) {
            IPedestal ped = (IPedestal)level.m_7702_(pos);
            if (ped == null) continue;
            ped.switchOff(level, thisPos);
        }
    }

    public static class Toggleable
    extends PedestalRedstoneWrapper {
        public Toggleable() {
            super(false);
        }
    }

    public static class AlwaysOn
    extends PedestalRedstoneWrapper {
        public AlwaysOn() {
            super(true);
        }
    }
}

