/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Settings;

public class PedestalBucketWrapper
implements IPedestalActionItemWrapper {
    private static final int UNSUCCESSFUL_TRIES_TO_CLEAN_QUEUE = 5;
    private final List<BlockPos> queueToDrain = new ArrayList<BlockPos>();
    private int unsuccessfulTries = 0;

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        int bucketRange;
        BlockPos pos = pedestal.getBlockPosition();
        if (!this.milkCows(level, pedestal, pos, bucketRange = ((Integer)Settings.COMMON.blocks.pedestal.bucketWrapperRange.get()).intValue(), stack) && !this.drainLiquid(level, pedestal, pos, bucketRange)) {
            pedestal.setActionCoolDown(2 * (Integer)Settings.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
            return;
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.bucketWrapperCooldown.get());
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private boolean drainLiquid(Level level, IPedestal pedestal, BlockPos pos, int bucketRange) {
        if (this.queueToDrain.isEmpty()) {
            this.updateQueueToDrain(level, pos, bucketRange);
        }
        if (this.queueToDrain.isEmpty()) {
            return false;
        }
        Iterator<BlockPos> iterator = this.queueToDrain.iterator();
        while (iterator.hasNext()) {
            BlockPos blockToDrain = iterator.next();
            BlockState blockState = level.m_8055_(blockToDrain);
            Fluid fluid = blockState.m_60819_().m_76152_();
            if (fluid != Fluids.f_76191_) {
                Optional<FluidStack> fs = this.drainBlock(level, blockToDrain, blockState.m_60734_(), blockState, fluid, IFluidHandler.FluidAction.SIMULATE);
                if (fs.isPresent()) {
                    FluidStack fluidStack = fs.get();
                    if (pedestal.fillConnectedTank(fluidStack, IFluidHandler.FluidAction.SIMULATE) != fluidStack.getAmount()) continue;
                    this.drainBlock(level, blockToDrain, blockState.m_60734_(), blockState, fluid, IFluidHandler.FluidAction.EXECUTE);
                    pedestal.fillConnectedTank(fluidStack);
                    iterator.remove();
                    return true;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        ++this.unsuccessfulTries;
        if (this.unsuccessfulTries >= 5) {
            this.queueToDrain.clear();
            this.unsuccessfulTries = 0;
        }
        return false;
    }

    private void updateQueueToDrain(Level world, BlockPos pos, int bucketRange) {
        for (int y = pos.m_123342_() + bucketRange; y >= pos.m_123342_() - bucketRange; --y) {
            for (int x = pos.m_123341_() - bucketRange; x <= pos.m_123341_() + bucketRange; ++x) {
                for (int z = pos.m_123343_() - bucketRange; z <= pos.m_123343_() + bucketRange; ++z) {
                    BlockPos currentBlockPos = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(currentBlockPos);
                    Fluid fluid = blockState.m_60819_().m_76152_();
                    if (fluid == Fluids.f_76191_ || !this.canDrainBlock(world, currentBlockPos, blockState.m_60734_(), blockState, fluid)) continue;
                    this.queueToDrain.add(currentBlockPos);
                }
            }
        }
    }

    private boolean canDrainBlock(Level world, BlockPos pos, Block block, BlockState blockState, Fluid fluid) {
        return this.drainBlock(world, pos, block, blockState, fluid, IFluidHandler.FluidAction.SIMULATE).isPresent();
    }

    private Optional<FluidStack> drainBlock(Level world, BlockPos pos, Block block, BlockState blockState, Fluid fluid, IFluidHandler.FluidAction action) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (!fluidBlock.canDrain(world, pos)) {
                return Optional.empty();
            }
            return Optional.of(fluidBlock.drain(world, pos, action));
        }
        if (block instanceof LiquidBlock) {
            int level = (Integer)blockState.m_61143_((Property)LiquidBlock.f_54688_);
            if (level != 0) {
                return Optional.empty();
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            return Optional.of(new FluidStack(fluid, 1000));
        }
        return Optional.empty();
    }

    private boolean milkCows(Level level, IPedestal pedestal, BlockPos pos, int bucketRange, ItemStack stack) {
        List entities = level.m_45976_(Cow.class, new AABB((double)pos.m_123341_() - (double)bucketRange, (double)pos.m_123342_() - (double)bucketRange, (double)pos.m_123343_() - (double)bucketRange, (double)pos.m_123341_() + (double)bucketRange, (double)pos.m_123342_() + (double)bucketRange, (double)pos.m_123343_() + (double)bucketRange));
        if (entities.isEmpty()) {
            return false;
        }
        Cow cow = (Cow)entities.get(level.f_46441_.nextInt(entities.size()));
        pedestal.getFakePlayer().ifPresent(fakePlayer -> this.milkCow(level, pedestal, pos, stack, cow, (FakePlayer)fakePlayer));
        return true;
    }

    private void milkCow(Level level, IPedestal pedestal, BlockPos pos, ItemStack stack, Cow cow, FakePlayer fakePlayer) {
        int fluidAdded;
        fakePlayer.m_6034_((double)pos.m_123341_(), 0.0, (double)pos.m_123343_());
        ItemStack bucketStack = new ItemStack((ItemLike)Items.f_42446_);
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, bucketStack);
        cow.m_6071_((Player)fakePlayer, InteractionHand.MAIN_HAND);
        if (fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42455_ && (fluidAdded = pedestal.fillConnectedTank(new FluidStack((Fluid)ForgeMod.MILK.get(), 1000))) == 0) {
            if (stack.m_41613_() == 1) {
                pedestal.setItem(new ItemStack((ItemLike)Items.f_42455_));
            } else if (stack.m_41613_() > 1) {
                stack.m_41774_(1);
                ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42455_));
                level.m_7967_((Entity)entity);
            }
        }
    }
}

