/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.items.util.FilteredBigItemStack;
import reliquary.items.util.FilteredItemStackHandler;
import reliquary.reference.Settings;

public class VoidTearItemStackHandler
extends FilteredItemStackHandler {
    private static final int FIRST_SLOT = 0;

    public VoidTearItemStackHandler() {
        super(new ArrayList<FilteredItemStackHandler.RemovableStack>());
    }

    public void setContainedStack(ItemStack stack) {
        this.setBigStack(0, new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(stack, (int)((Integer)Settings.COMMON.items.voidTear.itemLimit.get())), true));
    }

    public void setContainedStackAmount(int amount) {
        this.setTotalAmount(0, amount);
    }

    public ItemStack getTotalAmountStack() {
        FilteredBigItemStack bigStack = this.getBigStack(0);
        return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getOutputStack().m_41777_(), (int)bigStack.getAmount());
    }

    @Override
    protected boolean isValidForBigStackSlot(ItemStack stack, int bigStackSlot) {
        return bigStackSlot == 0 && super.isValidForBigStackSlot(stack, bigStackSlot);
    }

    public int getContainedAmount() {
        return this.getTotalAmount(0);
    }
}

