/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteredBigItemStack
implements INBTSerializable<CompoundTag> {
    private ItemStack filter;
    private int amount;
    private final int amountLimit;
    private final int unitWorth;
    private ItemStack outputStack = ItemStack.f_41583_;
    private ItemStack inputStack = ItemStack.f_41583_;

    public FilteredBigItemStack(Item filter, int amountLimit, int unitWorth) {
        this(new ItemStack((ItemLike)filter), amountLimit, unitWorth);
    }

    FilteredBigItemStack(int amountLimit) {
        this(amountLimit, 1);
    }

    FilteredBigItemStack(ItemStack filter, int amountLimit) {
        this(filter, amountLimit, 1);
    }

    private FilteredBigItemStack(ItemStack filter, int amountLimit, int unitWorth) {
        this(amountLimit, unitWorth);
        this.filter = filter.m_41777_();
        this.filter.m_41764_(1);
    }

    private FilteredBigItemStack(int amountLimit, int unitWorth) {
        this.amountLimit = amountLimit;
        this.unitWorth = unitWorth;
    }

    public ItemStack getFilterStack() {
        return this.filter;
    }

    public ItemStack getFullStack() {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.filter, (int)this.amount);
    }

    public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        ret.m_128365_("filter", (Tag)this.filter.serializeNBT());
        ret.m_128405_("amount", this.amount);
        return ret;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.filter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("filter"));
        this.setAmount(nbt.m_128451_("amount"));
    }

    void setAmount(int newAmount) {
        this.amount = newAmount;
        this.outputStack = this.filter.m_41777_();
        this.outputStack.m_41764_(Math.min(this.amount, this.filter.m_41741_()));
        int remainingSpace = this.amountLimit - this.amount;
        if (remainingSpace < this.filter.m_41741_()) {
            this.inputStack = this.filter.m_41777_();
            this.inputStack.m_41764_(this.filter.m_41741_() - remainingSpace);
        } else {
            this.inputStack = ItemStack.f_41583_;
        }
    }

    ItemStack insertItem(ItemStack stack, boolean simulate, boolean inputSlot) {
        boolean reachedLimit;
        ItemStack existing = inputSlot ? this.getInputStack() : this.getOutputStack();
        int limit = this.filter.m_41741_() - existing.m_41613_();
        int remainingTotal = this.worthToUnits(this.amountLimit - this.amount);
        if ((limit = Math.min(limit, remainingTotal)) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            this.setAmount(this.amount + this.unitsToWorth(reachedLimit ? limit : stack.m_41613_()));
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    ItemStack getOutputStack() {
        return this.outputStack;
    }

    ItemStack getInputStack() {
        return this.inputStack;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    void markDirty() {
        int inputCount = this.inputStack.m_41619_() ? 0 : this.inputStack.m_41613_();
        int remainingUnits = this.worthToUnits(this.amountLimit - this.amount);
        int outputCount = this.outputStack.m_41619_() ? 0 : this.outputStack.m_41613_();
        int amountUnits = this.worthToUnits(this.amount);
        if (inputCount != Math.max(this.filter.m_41741_() - remainingUnits, 0)) {
            this.setAmount(this.amount + this.unitWorth * (inputCount - Math.max(this.filter.m_41741_() - remainingUnits, 0)));
        }
        if (outputCount != Math.min(amountUnits, this.filter.m_41741_())) {
            this.setAmount(this.amount + this.unitsToWorth(outputCount - Math.min(amountUnits, this.filter.m_41741_())));
        }
    }

    private int worthToUnits(int valueWorth) {
        return valueWorth / this.unitWorth;
    }

    private int unitsToWorth(int valueUnits) {
        return this.unitWorth * valueUnits;
    }

    boolean isValid(ItemStack stack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.filter, (ItemStack)stack);
    }

    void setInputStack(ItemStack inputStack) {
        this.inputStack = inputStack;
    }

    void setOutputStack(ItemStack outputStack) {
        this.outputStack = outputStack;
    }

    public int getAmount() {
        return this.amount;
    }
}

