/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import reliquary.items.ToggleableItem;
import reliquary.items.util.ICuriosItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.MobHelper;

public class TwilightCloakItem
extends ToggleableItem
implements ICuriosItem {
    public TwilightCloakItem() {
        super(new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_6883_(ItemStack twilightCloak, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        this.updateInvisibility(twilightCloak, (Player)entity);
    }

    private void updateInvisibility(ItemStack twilightCloak, Player player) {
        if (!this.isEnabled(twilightCloak)) {
            return;
        }
        if (player.f_19853_.m_46803_(player.m_142538_()) > (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get()) {
            return;
        }
        MobEffectInstance quickInvisibility = new MobEffectInstance(MobEffects.f_19609_, 2, 0, false, false);
        player.m_7292_(quickInvisibility);
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.BODY;
    }

    @Override
    public void onWornTick(ItemStack twilightCloak, LivingEntity player) {
        this.updateInvisibility(twilightCloak, (Player)player);
    }

    private void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
    }

    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        this.doTwilightCloakCheck((LivingEvent)event);
    }

    private void doTwilightCloakCheck(LivingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob entityLiving = (Mob)entity;
            LivingEntity livingEntity = entityLiving.m_5448_();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            if (!InventoryHelper.playerHasItem(player, this, true, ICuriosItem.Type.BODY) || player.f_19853_.m_46803_(player.m_142538_()) > (Integer)Settings.COMMON.items.twilightCloak.maxLightLevel.get()) {
                return;
            }
            MobHelper.resetTarget(entityLiving);
        }
    }
}

