/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.blocks.tile.PedestalBlockEntity;
import reliquary.init.ModItems;
import reliquary.items.ItemBase;
import reliquary.items.MobCharmBeltItem;
import reliquary.items.MobCharmDefinition;
import reliquary.items.MobCharmRegistry;
import reliquary.network.PacketHandler;
import reliquary.network.PacketMobCharmDamage;
import reliquary.pedestal.PedestalRegistry;
import reliquary.reference.Settings;
import reliquary.util.LanguageHelper;
import reliquary.util.MobHelper;
import reliquary.util.NBTHelper;
import reliquary.util.WorldHelper;

public class MobCharmItem
extends ItemBase {
    private CharmInventoryHandler charmInventoryHandler = new CharmInventoryHandler();

    public MobCharmItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(((Integer)Settings.COMMON.items.mobCharm.durability.get()).intValue()).setNoRepair());
        MinecraftForge.EVENT_BUS.addListener(this::onEntityTargetedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingUpdate);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(MobCharmItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent(this.m_5524_() + ".tooltip", new Object[]{entityType.m_20676_().getString()}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(MobCharmItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return super.m_7626_(stack);
        }
        return new TextComponent(LanguageHelper.getLocalization(this.m_5524_(), entityType.m_20676_().getString()));
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group)) {
            return;
        }
        for (String entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            items.add((Object)this.getStackFor(entityRegistryName));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ != EnchantmentCategory.BREAKABLE && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        Entity entity;
        if (!(event.getTarget() instanceof Player) || event.getTarget() instanceof FakePlayer || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob entity2 = (Mob)entity;
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity2).ifPresent(charmDefinition -> {
            if (this.isMobCharmPresent((Player)event.getTarget(), (MobCharmDefinition)charmDefinition)) {
                MobHelper.resetTarget(entity2);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        var3_2 = event.getEntity();
        if (!(var3_2 instanceof Mob)) {
            return;
        }
        entity = (Mob)var3_2;
        player = null;
        var6_4 = entity.m_5448_();
        if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
        p = (Player)var6_4;
        if (!(entity.m_5448_() instanceof FakePlayer)) {
            player = p;
        } else if ((var6_4 = entity.m_142581_()) instanceof Player) {
            p = (Player)var6_4;
            if (!(entity.m_142581_() instanceof FakePlayer)) {
                player = p;
            }
        }
        if (player == null) {
            player = MobHelper.getTargetedPlayerFromMemory(entity).orElse(null);
        }
        if (player == null) {
            return;
        }
        finalPlayer = player;
        MobCharmRegistry.getCharmDefinitionFor((Entity)entity).filter((Predicate<MobCharmDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, resetTargetInLivingUpdateEvent(), (Lreliquary/items/MobCharmDefinition;)Z)()).ifPresent((Consumer<MobCharmDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$onLivingUpdate$1(net.minecraft.world.entity.player.Player net.minecraft.world.entity.Mob reliquary.items.MobCharmDefinition ), (Lreliquary/items/MobCharmDefinition;)V)((MobCharmItem)this, (Player)finalPlayer, (Mob)entity));
    }

    private void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getSource() == null || event.getSource().m_7639_() == null || !((entity = event.getSource().m_7639_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MobCharmRegistry.getCharmDefinitionFor(event.getEntity()).ifPresent(charmDefinition -> {
            if (!this.charmInventoryHandler.damagePlayersMobCharm(player, charmDefinition.getRegistryName())) {
                this.damageMobCharmInPedestal(player, charmDefinition.getRegistryName());
            }
        });
    }

    private void damageMobCharmInPedestal(Player player, String entityRegistryName) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.f_19853_.m_46472_().getRegistryName(), player.m_142538_(), (Integer)Settings.COMMON.items.mobCharm.pedestalRange.get());
        Level world = player.m_20193_();
        for (BlockPos pos : pedestalPositions) {
            WorldHelper.getBlockEntity((BlockGetter)world, pos, PedestalBlockEntity.class).ifPresent(pedestal -> this.damageMobCharmInPedestal(player, entityRegistryName, (PedestalBlockEntity)pedestal));
        }
    }

    private void damageMobCharmInPedestal(Player player, String entityRegistryName, PedestalBlockEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            if (MobCharmItem.isCharmFor(pedestalItem, entityRegistryName)) {
                if (pedestalItem.m_41773_() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get() > pedestalItem.m_41776_()) {
                    pedestal.destroyItem();
                } else {
                    pedestalItem.m_41721_(pedestalItem.m_41773_() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get());
                }
            } else if (pedestalItem.m_41720_() == ModItems.MOB_CHARM_BELT.get()) {
                ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).damageCharm(player, pedestalItem, entityRegistryName);
            }
        }
    }

    private boolean isMobCharmPresent(Player player, MobCharmDefinition charmDefinition) {
        return this.charmInventoryHandler.playerHasMobCharm(player, charmDefinition) || this.pedestalWithCharmInRange(player, charmDefinition);
    }

    private boolean isCharmOrBeltFor(ItemStack slotStack, String registryName) {
        return MobCharmItem.isCharmFor(slotStack, registryName) || slotStack.m_41720_() == ModItems.MOB_CHARM_BELT.get() && ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).hasCharm(slotStack, registryName);
    }

    static boolean isCharmFor(ItemStack slotStack, String registryName) {
        return slotStack.m_41720_() == ModItems.MOB_CHARM.get() && MobCharmItem.getEntityRegistryName(slotStack).equals(registryName);
    }

    private boolean pedestalWithCharmInRange(Player player, MobCharmDefinition charmDefinition) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.f_19853_.m_46472_().getRegistryName(), player.m_142538_(), (Integer)Settings.COMMON.items.mobCharm.pedestalRange.get());
        Level world = player.m_20193_();
        for (BlockPos pos : pedestalPositions) {
            if (!WorldHelper.getBlockEntity((BlockGetter)world, pos, PedestalBlockEntity.class).map(pedestal -> this.hasCharm(charmDefinition.getRegistryName(), (PedestalBlockEntity)pedestal)).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasCharm(String entityRegistryName, PedestalBlockEntity pedestal) {
        if (pedestal.isEnabled()) {
            ItemStack pedestalItem = pedestal.getItem();
            return this.isCharmOrBeltFor(pedestalItem, entityRegistryName);
        }
        return false;
    }

    static String getEntityRegistryName(ItemStack charm) {
        return NBTHelper.getString("entity", charm);
    }

    public static void setEntityRegistryName(ItemStack charm, String regName) {
        NBTHelper.putString("entity", charm, regName);
    }

    public ItemStack getStackFor(String entityRegistryName) {
        ItemStack ret = new ItemStack((ItemLike)this);
        MobCharmItem.setEntityRegistryName(ret, entityRegistryName);
        return ret;
    }

    public static ResourceLocation getEntityEggRegistryName(ItemStack charm) {
        return new ResourceLocation(MobCharmItem.getEntityRegistryName(charm));
    }

    public void setCharmInventoryHandler(CharmInventoryHandler charmInventoryHandler) {
        this.charmInventoryHandler = charmInventoryHandler;
    }

    private /* synthetic */ void lambda$onLivingUpdate$1(Player finalPlayer, Mob entity, MobCharmDefinition charmDefinition) {
        if (this.isMobCharmPresent(finalPlayer, charmDefinition)) {
            MobHelper.resetTarget(entity, true);
        }
    }

    public static class CharmInventoryHandler {
        public boolean playerHasMobCharm(Player player, MobCharmDefinition charmDefinition) {
            String registryName = charmDefinition.getRegistryName();
            for (ItemStack slotStack : player.m_150109_().f_35974_) {
                if (slotStack.m_41619_() || !((MobCharmItem)ModItems.MOB_CHARM.get()).isCharmOrBeltFor(slotStack, registryName)) continue;
                return true;
            }
            return false;
        }

        public boolean damagePlayersMobCharm(Player player, String entityRegistryName) {
            if (player.m_7500_()) {
                return true;
            }
            return this.damageCharmInPlayersInventory(player, entityRegistryName);
        }

        private Boolean damageCharmInPlayersInventory(Player player, String entityRegistryName) {
            for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(slot);
                if (stack.m_41619_()) continue;
                if (MobCharmItem.isCharmFor(stack, entityRegistryName)) {
                    if (stack.m_41773_() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get() > stack.m_41776_()) {
                        player.m_150109_().f_35974_.set(slot, (Object)ItemStack.f_41583_);
                        PacketHandler.sendToClient((ServerPlayer)player, new PacketMobCharmDamage(ItemStack.f_41583_, slot));
                    } else {
                        stack.m_41721_(stack.m_41773_() + (Integer)Settings.COMMON.items.mobCharm.damagePerKill.get());
                        PacketHandler.sendToClient((ServerPlayer)player, new PacketMobCharmDamage(stack, slot));
                    }
                    return true;
                }
                if (!this.damageMobCharmInBelt((ServerPlayer)player, entityRegistryName, stack)) continue;
                return true;
            }
            return false;
        }

        protected boolean damageMobCharmInBelt(ServerPlayer player, String entityRegistryName, ItemStack belt) {
            ItemStack charmStack;
            if (belt.m_41720_() == ModItems.MOB_CHARM_BELT.get() && !(charmStack = ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).damageCharm((Player)player, belt, entityRegistryName)).m_41619_()) {
                PacketHandler.sendToClient(player, new PacketMobCharmDamage(charmStack, -1));
                return true;
            }
            return false;
        }
    }
}

