/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.ItemBase;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;

public class KrakenShellItem
extends ItemBase {
    public KrakenShellItem() {
        super(new Item.Properties().m_41487_(1));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(Player player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.f_19312_ && player.m_36324_().m_38702_() > 0 && InventoryHelper.playerHasItem(player, (Item)ModItems.KRAKEN_SHELL.get());
            }

            @Override
            public boolean apply(Player player, LivingAttackEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Settings.COMMON.items.krakenShell.hungerCostPercent.get()).intValue() / 100.0f);
                player.m_36399_(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (world.m_46467_() % 3L != 0L) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).m_20069_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 5, 0, true, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 0, true, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 220, 0, true, false));
        }
    }
}

