/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.potion;

import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import reliquary.network.PacketFXThrownPotionImpact;
import reliquary.network.PacketHandler;
import reliquary.util.LogHelper;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public abstract class ThrownPotionEntity
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ThrownPotionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, Level world, ItemStack thrownStack) {
        super(entityType, world);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, Level world, Player player, ItemStack thrownStack) {
        super(entityType, (LivingEntity)player, world);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, Level world, double x, double y, double z, ItemStack thrownStack) {
        super(entityType, x, y, z, world);
        this.setItem(thrownStack);
    }

    private void setItem(ItemStack thrownStack) {
        this.f_19804_.m_135381_(ITEM, (Object)thrownStack);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_) {
            this.spawnParticles();
            this.doSplashEffect();
            this.m_146870_();
        }
    }

    abstract boolean hasLivingEntityEffect();

    private void doSplashEffect() {
        this.doGroundSplashEffect();
        if (!this.hasLivingEntityEffect()) {
            return;
        }
        AABB bb = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
        List eList = this.f_19853_.m_45976_(LivingEntity.class, bb);
        eList.forEach(this::doLivingSplashEffect);
    }

    abstract void doGroundSplashEffect();

    private void spawnParticles() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.15, this.f_19796_.nextDouble() * 0.2, this.f_19796_.nextGaussian() * 0.15);
        }
        this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(this.getColor(), this.m_20185_(), this.m_20186_(), this.m_20189_()), new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 32.0, this.f_19853_.m_46472_()));
    }

    abstract void doLivingSplashEffect(LivingEntity var1);

    abstract int getColor();

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_7846_() {
        ItemStack stack = (ItemStack)this.m_20088_().m_135370_(ITEM);
        if (stack.m_41720_() != Items.f_42736_ && stack.m_41720_() != Items.f_42739_) {
            LogHelper.error("EntityThrownPotion entity {} has no item?!", this.m_142049_());
            return new ItemStack((ItemLike)Items.f_42736_);
        }
        return stack;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

