/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.infernaltear;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.ReliquaryRecipeCategory;
import reliquary.compat.jei.infernaltear.InfernalTearRecipe;
import reliquary.init.ModItems;
import reliquary.items.InfernalTearItem;
import reliquary.reference.Reference;
import reliquary.util.LanguageHelper;
import reliquary.util.XpHelper;

public class InfernalTearRecipeCategory
extends ReliquaryRecipeCategory<InfernalTearRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("reliquary", "infernal_tear");
    private static final int INPUT_SLOT_1 = 0;
    private static final ResourceLocation BACKGROUNDS_TEXTURE = new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public InfernalTearRecipeCategory(IGuiHelper guiHelper) {
        super(UID);
        this.background = guiHelper.createDrawable(BACKGROUNDS_TEXTURE, 0, 76, 110, 25);
        this.localizedName = new TranslatableComponent("jei.reliquary.recipe.infernal_tear");
        ItemStack iconTear = new ItemStack((ItemLike)ModItems.INFERNAL_TEAR.get());
        InfernalTearItem.setTearTarget(iconTear, new ItemStack((ItemLike)Items.f_42416_));
        this.icon = guiHelper.createDrawableIngredient((Object)iconTear);
    }

    public Class<? extends InfernalTearRecipe> getRecipeClass() {
        return InfernalTearRecipe.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(InfernalTearRecipe recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfernalTearRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 16, 0);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        recipeLayout.getItemStacks().set(0, (List)ingredientsInputs.get(0));
    }

    public void draw(InfernalTearRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        int experiencePoints = recipe.getExperiencePoints();
        String points = experiencePoints + " " + LanguageHelper.getLocalization("jei.reliquary.recipe.infernal_tear.xp", new Object[0]);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int stringWidth = fontRenderer.m_92895_(points);
        fontRenderer.m_92883_(matrixStack, points, (float)((double)this.background.getWidth() / 2.0 + ((double)this.background.getWidth() / 2.0 + 16.0 - (double)stringWidth) / 2.0), 5.0f, -8355712);
        this.drawLevels(matrixStack, experiencePoints, fontRenderer);
    }

    private void drawLevels(PoseStack matrixStack, int experiencePoints, Font fontRenderer) {
        int numberOfLevels = XpHelper.getLevelForExperience(experiencePoints);
        this.drawXpBar(matrixStack, experiencePoints, numberOfLevels);
        this.drawXpLevel(matrixStack, fontRenderer, numberOfLevels);
    }

    private void drawXpLevel(PoseStack matrixStack, Font fontRenderer, int numberOfLevels) {
        String xpLevel = Integer.toString(numberOfLevels);
        int x = (this.background.getWidth() - fontRenderer.m_92895_(xpLevel)) / 2;
        int y = this.background.getHeight() - 10;
        fontRenderer.m_92883_(matrixStack, xpLevel, (float)x + 1.0f, (float)y, 0);
        fontRenderer.m_92883_(matrixStack, xpLevel, (float)x - 1.0f, (float)y, 0);
        fontRenderer.m_92883_(matrixStack, xpLevel, (float)x, (float)y + 1.0f, 0);
        fontRenderer.m_92883_(matrixStack, xpLevel, (float)x, (float)y - 1.0f, 0);
        fontRenderer.m_92883_(matrixStack, xpLevel, (float)x, (float)y, 8453920);
    }

    private void drawXpBar(PoseStack matrixStack, int experiencePoints, int level) {
        int partialXp = experiencePoints - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        if (partialXp == 0) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUNDS_TEXTURE);
        float textureWidth = 256.0f;
        float textureHeight = 256.0f;
        float minU = 0.0f;
        float minV = 101.0f;
        float maxU = 110.0f * ((float)partialXp / (float)maxBarExperience);
        float maxV = 106.0f;
        float width = maxU - minU;
        float height = maxV - minV;
        float x = 0.0f;
        float y = (float)this.background.getHeight() - 5.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        bufferBuilder.m_85982_(matrix, x, y + height, 0.0f).m_7421_(minU / textureWidth, maxV / textureHeight).m_5752_();
        bufferBuilder.m_85982_(matrix, x + width, y + height, 0.0f).m_7421_(maxU / textureWidth, maxV / textureHeight).m_5752_();
        bufferBuilder.m_85982_(matrix, x + width, y, 0.0f).m_7421_(maxU / textureWidth, minV / textureHeight).m_5752_();
        bufferBuilder.m_85982_(matrix, x, y, 0.0f).m_7421_(minU / textureWidth, minV / textureHeight).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }
}

