/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.cauldron;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.ReliquaryRecipeCategory;
import reliquary.compat.jei.cauldron.CauldronRecipeJEI;
import reliquary.init.ModBlocks;
import reliquary.reference.Reference;

public class CauldronRecipeCategory
extends ReliquaryRecipeCategory<CauldronRecipeJEI> {
    public static final ResourceLocation UID = new ResourceLocation("reliquary", "cauldron");
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int CAULDRON_SLOT = 3;
    private static final int FIRST_ADDITIONAL_SLOT = 4;
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;

    public CauldronRecipeCategory(IGuiHelper guiHelper) {
        super(UID);
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png"), 96, 0, 107, 51);
        this.localizedName = new TranslatableComponent("jei.reliquary.recipe.cauldron");
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get()));
    }

    public Class<? extends CauldronRecipeJEI> getRecipeClass() {
        return CauldronRecipeJEI.class;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CauldronRecipeJEI recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CauldronRecipeJEI recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 33);
        recipeLayout.getItemStacks().init(1, false, 90, 33);
        recipeLayout.getItemStacks().init(3, false, 44, 33);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        ItemStack output = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)).get(0);
        this.initAdditionalSlots(recipeLayout, ingredientsInputs.size());
        recipeLayout.getItemStacks().set(0, (List)ingredientsInputs.get(0));
        recipeLayout.getItemStacks().set(1, output);
        recipeLayout.getItemStacks().set(3, new ItemStack((ItemLike)ModBlocks.APOTHECARY_CAULDRON.get(), 1));
        this.setAdditionalSlotContents(recipeLayout, ingredientsInputs);
    }

    private void setAdditionalSlotContents(IRecipeLayout recipeLayout, List<List<ItemStack>> inputs) {
        for (int i = 1; i < inputs.size(); ++i) {
            recipeLayout.getItemStacks().set(i - 1 + 4, inputs.get(i));
        }
    }

    private void initAdditionalSlots(IRecipeLayout recipeLayout, int inputCount) {
        int left = 44 - (inputCount - 2) * 9;
        for (int i = 0; i < inputCount; ++i) {
            recipeLayout.getItemStacks().init(4 + i, false, left + i * 18, 0);
        }
    }
}

