/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.text.SimpleDateFormat;
import java.util.List;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import reliquary.blocks.AlkahestryAltarBlock;
import reliquary.blocks.tile.AlkahestryAltarBlockEntity;
import reliquary.compat.jade.provider.JadeHelper;
import reliquary.reference.Settings;
import reliquary.util.LanguageHelper;

public class DataProviderAltar
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    @Nullable
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        return super.getIcon(accessor, config, currentIcon);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        if (((Boolean)Settings.CLIENT.wailaShiftForInfo.get()).booleanValue() && !accessor.getPlayer().m_6047_()) {
            tooltip.add(Component.m_130674_((String)(ChatFormatting.ITALIC + LanguageHelper.getLocalization("waila.reliquary.shift_for_more", new Object[0]) + ChatFormatting.RESET)));
            return;
        }
        if (!(accessor.getBlock() instanceof AlkahestryAltarBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof AlkahestryAltarBlockEntity)) {
            return;
        }
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)blockEntity;
        IElementHelper helper = tooltip.getElementHelper();
        if (!altar.isActive()) {
            tooltip.add(Component.m_130674_((String)(ChatFormatting.RED + LanguageHelper.getLocalization("waila.reliquary.altar.inactive", new Object[0]) + ChatFormatting.RESET)));
            Vec2 delta = new Vec2(0.0f, -4.0f);
            IElement redstoneIcon = helper.item(Items.f_42451_.m_7968_(), JadeHelper.ITEM_ICON_SCALE);
            IElement requirementText = helper.text((Component)new TextComponent(String.format("%d / %d", altar.getRedstoneCount(), Settings.COMMON.blocks.altar.redstoneCost.get())));
            redstoneIcon.size(redstoneIcon.getSize().m_165910_(delta)).translate(delta);
            requirementText.size(requirementText.getSize().m_165910_(delta)).translate(delta.m_165910_(new Vec2(0.0f, (redstoneIcon.getSize().f_82471_ - requirementText.getSize().f_82471_) / 2.0f)));
            tooltip.add(List.of(redstoneIcon, requirementText));
            return;
        }
        tooltip.add(Component.m_130674_((String)(ChatFormatting.GREEN + LanguageHelper.getLocalization("waila.reliquary.altar.active", new Object[0]))));
        int cycleTime = accessor.getServerData().m_128451_("cycleTime");
        tooltip.add(Component.m_130674_((String)LanguageHelper.getLocalization("waila.reliquary.altar.time_remaining", new SimpleDateFormat("mm:ss").format(cycleTime * 50))));
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity t, boolean showDetails) {
        AlkahestryAltarBlockEntity be = (AlkahestryAltarBlockEntity)t;
        data.m_128405_("cycleTime", be.getCycleTime());
    }
}

