/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.components;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;

public abstract class Component {
    public int getPadding() {
        return 1;
    }

    public int getHeight() {
        return this.getHeightInternal() + this.getPadding() * 2;
    }

    public int getWidth() {
        return this.getWidthInternal() + this.getPadding() * 2;
    }

    public void render(PoseStack matrixStack, int x, int y) {
        this.renderInternal(matrixStack, x + this.getPadding(), y + this.getPadding());
    }

    public boolean shouldRender() {
        return true;
    }

    public abstract int getHeightInternal();

    public abstract int getWidthInternal();

    public abstract void renderInternal(PoseStack var1, int var2, int var3);

    protected void blit(int x, int y, int textureX, int textureY, int width, int height) {
        this.blit(x, y, textureX, textureY, width, height, 256.0f, 256.0f);
    }

    protected void blit(int x, int y, int textureX, int textureY, int width, int height, float textureWidth, float textureHeight) {
        float minU = (float)textureX / textureWidth;
        float maxU = (float)(textureX + width) / textureWidth;
        float minV = (float)textureY / textureHeight;
        float maxV = (float)(textureY + height) / textureHeight;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(minU, maxV).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(maxU, maxV).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(maxU, minV).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(minU, minV).m_5752_();
        tessellator.m_85914_();
    }
}

